/*
 * Decompiled with CFR 0.152.
 */
package de.nece.ccrle.febina;

import at.ac.univie.iss.apm.PerformanceModel;
import at.ac.univie.iss.descriptors.qos.PerformanceDescriptorImpl;
import at.ac.univie.iss.descriptors.qos.RequestDescriptorImpl;
import java.io.FileWriter;

public class FEBiNAPerformanceModel
implements PerformanceModel {
    static final int ntypes = 5;
    static final double[] Memory = new double[]{4.0, 18.0, 37.0, 123.0, 6.0};
    static final int[] NNZ = new int[]{35, 242, 536, 2245, 56};
    static final int nnp = 2;
    static final double max_mem_per_process = 1.8;
    static final double[] a = new double[]{74.2, 214.379, 216.85, 95.42, -475.0};
    static final double[] b = new double[]{1.06E-4, 2.666906E-5, 1.72E-5, 6.64E-5, 1.647E-4};
    static final double[] D_par_factor = new double[]{0.0078, 0.0018, 0.0, 0.0, 0.0};
    static final double[] D_ser_factor = new double[]{1.0E-4, 5.0E-5, 0.0, 0.0, 0.0};
    static double MemSafety = 25.0;
    static double TimeSafety = 0.0;

    private int getNumOfNodes(String string) {
        int n = string.indexOf("<number-of-nodes>");
        String string2 = string.substring(new String("<number-of-nodes>").length() + n);
        String string3 = string2.substring(0, string2.indexOf("</")).trim();
        return Integer.parseInt(string3);
    }

    public String getPerformanceEstimate(String string, String string2) {
        RequestDescriptorImpl requestDescriptorImpl = new RequestDescriptorImpl(string);
        int n = Integer.parseInt(requestDescriptorImpl.getPerformanceParameter("NumberOfPoints"));
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < 5; ++i) {
            nArray[i] = Integer.parseInt(requestDescriptorImpl.getPerformanceParameter("NumberElementsOfType" + i));
        }
        String string3 = requestDescriptorImpl.getPerformanceParameter("SolverType");
        double d = Double.parseDouble(requestDescriptorImpl.getPerformanceParameter("SolverTolerance"));
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter("/tmp/FEBINAPerformanceModel_DebugFile.txt");
        }
        catch (Exception exception) {
            System.out.println("Can not open debug file /tmp/FEBINAPerformanceModel_DebugFile.txt");
        }
        try {
            fileWriter.write("First entry into the FEBINA Performance Model Debug File \n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.getNumOfNodes(string2);
        int n3 = 2 * n2;
        try {
            fileWriter.write("getNumOfNodes(machineDesc) returned nnodes=" + Integer.toString(n2) + ". \n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d2 = 0.0;
        for (int i = 0; i < 5; ++i) {
            d2 += Memory[i] * (double)nArray[i];
        }
        d2 /= 1048576.0;
        d2 *= 1.0 + MemSafety / 100.0;
        try {
            fileWriter.write("Computed Memory Requirement is " + Double.toString(d2) + " GByte \n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d3 = 0.0;
        if (d2 > 1.8 * (double)n3) {
            d3 = Double.POSITIVE_INFINITY;
        } else {
            int n4 = 0;
            for (int i = 0; i < 5; ++i) {
                int n5 = NNZ[i] * nArray[i];
                double d4 = 0.0;
                double d5 = (double)n5 / (double)n3;
                d4 = a[i] + b[i] * d5;
                d3 += d4 * (double)n5;
                n4 += n5;
            }
            double d6 = Math.log(d) / Math.log(10.0);
            d3 = d3 / (double)n4 * Math.pow(10.0, -0.8289 - 0.0423 * d6 + 0.017 * d6 * d6);
            try {
                fileWriter.write("Computed FEBINA time is " + Double.toString(d3) + " sec \n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n6 = 0;
            for (int i = 2; i < 5; ++i) {
                if (nArray[i] <= 0) continue;
                ++n6;
            }
            if (n6 == 0) {
                double d7 = 0.0;
                int n7 = 0;
                for (int i = 0; i < 5; ++i) {
                    int n8 = nArray[i];
                    n7 += n8;
                    d7 += (double)n8 * (double)n8 * (D_par_factor[i] / (double)n2 + D_ser_factor[i]);
                }
                try {
                    fileWriter.write("Computed DRAMA time is " + Double.toString(d7 / (double)n7) + " sec \n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                d3 += d7 / (double)n7;
            }
        }
        PerformanceDescriptorImpl performanceDescriptorImpl = new PerformanceDescriptorImpl();
        performanceDescriptorImpl.setRuntime(d3);
        try {
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return performanceDescriptorImpl.toString();
    }
}

