/*
 * Decompiled with CFR 0.152.
 */
package de.nece.ccrl.sessionmanager;

import de.nece.ccrl.sessionmanager.Session;
import de.nece.ccrl.sessionmanager.SessionContext;
import de.nece.ccrl.sessionmanager.SessionContextException;
import de.nece.ccrl.sessionmanager.SessionId;
import de.nece.ccrl.sessionmanager.SessionManager;
import de.nece.ccrl.sessionmanager.SessionManagerImpl;
import de.nece.ccrl.sessionmanager.SessionPort;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SessionContextImpl
implements SessionContext {
    SessionId id;
    String classname;
    HashMap porttable;
    HashSet keys;

    public SessionContextImpl(String sessionclassname, SessionId sid, HashSet portnames) throws SessionContextException {
        Session session;
        int portnumber = portnames.size();
        try {
            Class<?> s = Class.forName(sessionclassname);
            session = (Session)s.newInstance();
        }
        catch (Exception e) {
            throw new SessionContextException("Undefined Session Class");
        }
        this.classname = sessionclassname;
        this.id = sid;
        this.porttable = new HashMap(2 * portnumber);
        this.keys = portnames;
        Iterator portnameit = portnames.iterator();
        while (portnameit.hasNext()) {
            this.porttable.put(portnameit.next(), new SessionPort());
        }
        session.setContext(this);
        session.start();
    }

    public SessionContextImpl(String sessionclassname, SessionId sid) throws SessionContextException {
        Session session;
        try {
            Class<?> s = Class.forName(sessionclassname);
            session = (Session)s.newInstance();
        }
        catch (Exception e) {
            throw new SessionContextException("Undefined Session Class");
        }
        this.id = sid;
        this.porttable = new HashMap(2);
        this.keys = new HashSet(2);
        session.setContext(this);
        session.start();
    }

    public SessionId getSessionId() {
        return this.id;
    }

    public String getSessionClassName() {
        return this.classname;
    }

    public HashSet getPortNames() {
        return this.keys;
    }

    public SessionPort getSessionPort(String portname) throws SessionContextException {
        SessionPort p = (SessionPort)this.porttable.get(portname);
        if (p == null) {
            throw new SessionContextException("There is no " + portname + " port");
        }
        return p;
    }

    public synchronized SessionPort setSessionPort(String portname) throws SessionContextException {
        if (this.porttable.containsKey(portname)) {
            throw new SessionContextException("The port " + portname + " already exists");
        }
        this.keys.add(portname);
        SessionPort p = new SessionPort();
        this.porttable.put(portname, p);
        return p;
    }

    public synchronized void terminateContext(int timeout) throws SessionContextException {
        Iterator nameit = this.keys.iterator();
        while (nameit.hasNext()) {
            String portname = (String)nameit.next();
            SessionPort p = (SessionPort)this.porttable.get(portname);
            if (p == null) continue;
            p.setTerminate();
        }
        try {
            Thread.sleep(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SessionManagerImpl sm = new SessionManagerImpl();
        ((SessionManager)sm).removeContext(this.id);
    }
}

