/*
 * Decompiled with CFR 0.152.
 */
package de.nece.ccrl.sessionmanager;

import de.nece.ccrl.sessionmanager.SessionContextException;
import de.nece.ccrl.sessionmanager.Timer;

public class SessionPort {
    Object value = null;
    boolean isnew = false;
    boolean isterm = false;

    SessionPort() {
    }

    public synchronized void setValue(Object request) throws SessionContextException {
        while (this.isnew && !this.isterm) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isterm) {
            throw new SessionContextException("No more writes");
        }
        this.value = request;
        this.isnew = true;
        this.notifyAll();
    }

    public synchronized void setValue(Object request, int timeout) throws SessionContextException {
        Timer t = new Timer(timeout);
        t.start();
        while (this.isnew && !this.isterm && !t.timedout()) {
            try {
                this.wait(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isterm) {
            throw new SessionContextException("No more writes");
        }
        if (t.timedout()) {
            throw new SessionContextException("Operation timed out");
        }
        this.value = request;
        this.isnew = true;
        this.notifyAll();
    }

    public synchronized Object getValue() throws SessionContextException {
        while (!this.isnew && !this.isterm) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isterm && !this.isnew) {
            throw new SessionContextException("No more reads");
        }
        this.isnew = false;
        this.notifyAll();
        return this.value;
    }

    public synchronized Object getValue(int timeout) throws SessionContextException {
        Timer t = new Timer(timeout);
        t.start();
        while (!(this.isnew || this.isterm || t.timedout())) {
            try {
                this.wait(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isterm && !this.isnew) {
            throw new SessionContextException("No more reads");
        }
        if (t.timedout()) {
            throw new SessionContextException("Operation timed out");
        }
        this.isnew = false;
        this.notifyAll();
        return this.value;
    }

    public synchronized void setTerminate() {
        this.isterm = true;
        this.notifyAll();
    }
}

