/*
 * Decompiled with CFR 0.152.
 */
import at.ac.univie.iss.registry.Attribute;
import at.ac.univie.iss.registry.RegistryImpl;
import at.ac.univie.iss.registry.RegistryImplServiceLocator;
import at.ac.univie.iss.registry.ServiceDescription;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.rpc.ServiceException;

public class RegistryTool {
    private PrintWriter exceptionWriter;
    private final String FILE_NAME = "exceptions.log";
    private Date currentDate;
    private String registryURI;
    private String serviceURI;
    private String attributesFile;
    private String commandArgument;

    public RegistryTool(String[] stringArray) {
        boolean bl;
        block16: {
            this.FILE_NAME = "exceptions.log";
            this.currentDate = new Date();
            this.registryURI = new String("");
            this.serviceURI = new String("");
            this.attributesFile = new String("");
            this.commandArgument = new String("");
            try {
                this.exceptionWriter = new PrintWriter(new BufferedWriter(new FileWriter("exceptions.log", true)));
            }
            catch (IOException iOException) {
                System.err.println("Error writing in exceptions.log");
                System.err.println(iOException);
            }
            bl = true;
            if (stringArray.length == 4 || stringArray.length == 6 || stringArray.length == 3 && stringArray[2].equals("-l")) {
                if (this.processArguments(stringArray)) {
                    System.out.println("\n========== registry-tool ==========");
                    System.out.println("uri2REGISTRYwsdl: " + this.registryURI);
                    System.out.println("uri2SERVICEwsdl: " + this.serviceURI);
                    System.out.println("attributesFile: " + this.attributesFile + "\n");
                    try {
                        RegistryImpl registryImpl = this.createStub();
                        if (registryImpl != null) {
                            if (this.commandArgument.equals("-r")) {
                                System.out.println("publishService()...");
                                registryImpl.publishService(this.makeService(this.serviceURI, this.attributesFile));
                            } else if (this.commandArgument.equals("-u")) {
                                System.out.println("removeService()...");
                                registryImpl.removeService(this.serviceURI);
                            } else if (this.commandArgument.equals("-l")) {
                                System.out.println("list()...\n");
                                Vector vector = registryImpl.query(null);
                                this.list(vector);
                            } else {
                                bl = false;
                            }
                            break block16;
                        }
                        System.out.println("The specified registry: " + this.registryURI + " is incorrect!");
                    }
                    catch (RemoteException remoteException) {
                        System.out.println(remoteException.getMessage());
                        this.exceptionLog("");
                        remoteException.printStackTrace(this.exceptionWriter);
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (!bl) {
            System.out.println("\nPlease start registry tool as follow:");
            System.out.println("\nUsage: java -jar tool" + File.separator + "registry-tool.jar -d uri2REGISTRYwsdl <options>\n" + "\nwhere possible options include:" + "\n     -r uri2SERVICEwsdl [-attrfile someAttributeFile]    publish a service" + "\n     -u uri2SERVICEwsdl                                  remove a service" + "\n     -l                                                  print a list of all published services");
        }
        this.exceptionWriter.close();
    }

    private void list(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            System.out.println("Published services:");
            while (iterator.hasNext()) {
                ServiceDescription serviceDescription = (ServiceDescription)iterator.next();
                Attribute[] attributeArray = serviceDescription.getAttributes();
                System.out.println("--> Service WSDL endpoint " + serviceDescription.getWsdlEndpoint());
                if (attributeArray == null) continue;
                for (int i = 0; i < attributeArray.length; ++i) {
                    System.out.println("    - Attribute name: " + attributeArray[i].getName() + ", value: " + attributeArray[i].getValue());
                }
            }
        }
    }

    private RegistryImpl createStub() {
        RegistryImpl registryImpl = null;
        if (this.checkURI(this.registryURI)) {
            RegistryImplServiceLocator registryImplServiceLocator = new RegistryImplServiceLocator();
            try {
                registryImpl = registryImplServiceLocator.getreg(new URL(this.registryURI));
            }
            catch (MalformedURLException malformedURLException) {
                System.out.print("java.net.MalformedURLException: ");
                this.exceptionLog("");
                malformedURLException.printStackTrace(this.exceptionWriter);
            }
            catch (ServiceException serviceException) {
                System.out.print("javax.xml.rpc.ServiceException: ");
                this.exceptionLog("");
                serviceException.printStackTrace(this.exceptionWriter);
            }
        }
        return registryImpl;
    }

    private boolean checkURI(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.print("java.net.MalformedURLException: ");
            this.exceptionLog("");
            malformedURLException.printStackTrace(this.exceptionWriter);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.print("java.net.UnknownHostException: ");
            this.exceptionLog("");
            unknownHostException.printStackTrace(this.exceptionWriter);
        }
        catch (ConnectException connectException) {
            System.out.print("java.net.ConnectException: ");
            this.exceptionLog("");
            connectException.printStackTrace(this.exceptionWriter);
        }
        catch (UnknownServiceException unknownServiceException) {
            System.out.print("java.net.UnknownServiceException: ");
            this.exceptionLog("");
            unknownServiceException.printStackTrace(this.exceptionWriter);
        }
        catch (IOException iOException) {
            System.out.print("java.io.IOException: ");
            this.exceptionLog("");
            iOException.printStackTrace(this.exceptionWriter);
        }
        return false;
    }

    private void exceptionLog(String string) {
        this.currentDate.setTime(System.currentTimeMillis());
        this.exceptionWriter.println(this.currentDate + ": " + string);
    }

    private ServiceDescription makeService(String string, String string2) {
        int n = 0;
        int n2 = 0;
        ServiceDescription serviceDescription = new ServiceDescription();
        try {
            if (!string2.equals("")) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(string2));
                Attribute[] attributeArray = properties.propertyNames();
                while (attributeArray.hasMoreElements()) {
                    attributeArray.nextElement();
                    ++n;
                }
                attributeArray = new Attribute[n];
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    attributeArray[n2] = new Attribute();
                    attributeArray[n2].setName(string3);
                    attributeArray[n2++].setValue(properties.getProperty(string3));
                }
                serviceDescription.setAttributes(attributeArray);
                serviceDescription.setWsdlEndpoint(string);
            } else {
                serviceDescription.setWsdlEndpoint(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.print(fileNotFoundException);
            this.exceptionLog("");
            fileNotFoundException.printStackTrace(this.exceptionWriter);
        }
        catch (IOException iOException) {
            System.out.print(iOException);
            this.exceptionLog("");
            iOException.printStackTrace(this.exceptionWriter);
        }
        catch (Exception exception) {
            System.out.print(exception);
            this.exceptionLog("");
            exception.printStackTrace(this.exceptionWriter);
        }
        return serviceDescription;
    }

    private boolean processArguments(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            if (string.equals("-d") && (stringArray.length == 3 || stringArray.length == 4 || stringArray.length == 6)) {
                bl = true;
                this.registryURI = stringArray[i + 1];
                continue;
            }
            if (string.equals("-l") && stringArray.length == 3) {
                bl2 = true;
                this.commandArgument = string;
                continue;
            }
            if (string.equals("-r")) {
                bl2 = true;
                this.commandArgument = string;
                this.serviceURI = stringArray[i + 1];
                continue;
            }
            if (string.equals("-u") && stringArray.length == 4) {
                bl2 = true;
                this.commandArgument = string;
                this.serviceURI = stringArray[i + 1];
                continue;
            }
            if (string.equals("-attrfile")) {
                this.attributesFile = stringArray[i + 1];
                continue;
            }
            return false;
        }
        return bl && bl2;
    }

    public static void main(String[] stringArray) {
        new RegistryTool(stringArray);
    }
}

