/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption;

import java.security.Key;
import java.util.HashMap;
import java.util.Vector;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.encryption.EncryptionMethodSpi;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EncryptionMethod
extends Algorithm {
    static Category cat;
    static boolean _alreadyInitialized;
    static HashMap _algorithmHash;
    EncryptionMethodSpi _emSpi;
    EncryptionMethodParams _encMethodParams;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$encryption$EncryptionMethod;

    public String getBaseNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    public String getBaseLocalName() {
        return "EncryptionMethod";
    }

    public boolean getUsableInEncryptedData() {
        int n = this._emSpi.getImplementedAlgorithmType();
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    public boolean getUsableInEncryptedKey() {
        int n = this._emSpi.getImplementedAlgorithmType();
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return true;
            }
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public byte[] wrap(Key key, Key key2) throws XMLSecurityException {
        return this._emSpi.engineWrap(key, key2);
    }

    public byte[] wrap(Key key, Key key2, byte[] byArray) throws XMLSecurityException {
        return this._emSpi.engineWrap(key, key2, byArray);
    }

    public Key unwrap(byte[] byArray, Key key, String string) throws XMLSecurityException {
        return this._emSpi.engineUnwrap(byArray, key, string);
    }

    public byte[] encrypt(byte[] byArray, Key key) throws XMLSecurityException {
        return this._emSpi.engineEncrypt(byArray, key);
    }

    public byte[] encrypt(byte[] byArray, Key key, byte[] byArray2) throws XMLSecurityException {
        return this._emSpi.engineEncrypt(byArray, key, byArray2);
    }

    public byte[] decrypt(byte[] byArray, Key key) throws XMLSecurityException {
        return this._emSpi.engineDecrypt(byArray, key);
    }

    public EncryptionMethodParams getParams() {
        return this._encMethodParams;
    }

    public int getIvLength() {
        return this._emSpi.engineGetIvLength();
    }

    public int getBlockSize() {
        return this._emSpi.engineGetBlockSize();
    }

    public Key createSecretKeyFromBytes(byte[] byArray) throws XMLSecurityException {
        String string = JCEMapper.getJCEKeyAlgorithmFromURI(this._emSpi.getImplementedAlgorithmURI(), this._emSpi.getRequiredProviderName());
        return new SecretKeySpec(byArray, string);
    }

    public static void providerInit() {
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static boolean register(String string, String string2) {
        Vector<String> vector = (Vector<String>)_algorithmHash.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            _algorithmHash.put(string, vector);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            if (clazz != null) {
                EncryptionMethodSpi encryptionMethodSpi = (EncryptionMethodSpi)clazz.newInstance();
                if (encryptionMethodSpi.getRequiredProviderAvailable()) {
                    vector.add(string2);
                    return true;
                }
                cat.debug((Object)("Try to register class " + string2 + " but Provider " + encryptionMethodSpi.getRequiredProviderName() + " not available"));
            } else {
                cat.debug((Object)("Try to register class " + string2 + " but Class not available"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            cat.debug((Object)("Try to register class " + string2 + " but Class not found: "), (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            cat.debug((Object)("Try to register class " + string2 + " but Class not found: "), (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            cat.debug((Object)("Try to register class " + string2 + " but Class not found: "), (Throwable)instantiationException);
        }
        return false;
    }

    public String encryptB64(byte[] byArray, Key key, byte[] byArray2) throws XMLSecurityException {
        byte[] byArray3 = this.encrypt(byArray, key, byArray2);
        return Base64.encode(byArray3);
    }

    public String encryptB64(byte[] byArray, Key key) throws XMLSecurityException {
        byte[] byArray2 = this.encrypt(byArray, key);
        return Base64.encode(byArray2);
    }

    public byte[] decryptB64(String string, Key key) throws XMLSecurityException {
        byte[] byArray = Base64.decode(string);
        return this.decrypt(byArray, key);
    }

    public String wrapB64(Key key, Key key2) throws XMLSecurityException {
        byte[] byArray = this.wrap(key, key2);
        return Base64.encode(byArray);
    }

    public String wrapB64(Key key, Key key2, byte[] byArray) throws XMLSecurityException {
        byte[] byArray2 = this.wrap(key, key2, byArray);
        return Base64.encode(byArray2);
    }

    public Key unwrapB64(String string, Key key, String string2) throws XMLSecurityException {
        byte[] byArray = Base64.decode(string);
        return this.unwrap(byArray, key, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._emSpi = null;
        this._encMethodParams = null;
    }

    public EncryptionMethod(Document document, String string) throws XMLSecurityException {
        this(document, string, null);
    }

    public EncryptionMethod(Document document, String string, EncryptionMethodParams encryptionMethodParams) throws XMLSecurityException {
        super(document, string);
        this.this();
        Vector vector = (Vector)_algorithmHash.get(string);
        if (vector == null) {
            Object[] objectArray = new Object[]{"Could not find a registered Provider"};
            throw new XMLSecurityException("empty");
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                String string2 = (String)vector.elementAt(n);
                this._emSpi = (EncryptionMethodSpi)Class.forName(string2).newInstance();
                if (this._emSpi != null && this._emSpi.getRequiredProviderAvailable()) {
                    cat.debug((Object)("Create URI \"" + string + "\" class \"" + string2 + '\"'));
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLSecurityException("empty", classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLSecurityException("empty", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new XMLSecurityException("empty", instantiationException);
            }
            ++n;
        }
        if (this._emSpi == null) {
            Object[] objectArray = new Object[]{"Could not find a registered Provider"};
            throw new XMLSecurityException("empty");
        }
        this._encMethodParams = this._emSpi.engineInit(document, encryptionMethodParams);
        if (this._encMethodParams != null) {
            this._constructionElement.appendChild(this._encMethodParams.createChildNodes(this._doc));
        }
    }

    public EncryptionMethod(Element element, String string) throws XMLSecurityException {
        super(element, string);
        this.this();
        String string2 = this.getAlgorithmURI();
        Vector vector = (Vector)_algorithmHash.get(string2);
        if (vector == null) {
            Object[] objectArray = new Object[]{"Could not find a registered Provider"};
            throw new XMLSecurityException("empty");
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                String string3 = (String)vector.elementAt(n);
                this._emSpi = (EncryptionMethodSpi)Class.forName(string3).newInstance();
                if (this._emSpi != null && this._emSpi.getRequiredProviderAvailable()) {
                    cat.debug((Object)("Create URI \"" + string2 + "\" class \"" + string3 + '\"'));
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLSecurityException("empty", classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLSecurityException("empty", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new XMLSecurityException("empty", instantiationException);
            }
            ++n;
        }
        if (this._emSpi == null) {
            Object[] objectArray = new Object[]{"Could not find a registered Provider"};
            throw new XMLSecurityException("empty");
        }
        this._encMethodParams = this._emSpi.engineInit(this._constructionElement);
    }

    static {
        Class clazz = class$org$apache$xml$security$algorithms$encryption$EncryptionMethod;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$algorithms$encryption$EncryptionMethod = EncryptionMethod.class$("org.apache.xml.security.algorithms.encryption.EncryptionMethod");
        }
        cat = Category.getInstance((String)clazz.getName());
        _alreadyInitialized = false;
        _algorithmHash = null;
    }
}

