/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SignatureBaseRSA
extends SignatureAlgorithmSpi {
    static Category cat;
    private Signature _signatureAlgorithm;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$implementations$SignatureBaseRSA;
    static /* synthetic */ Class class$java$security$PublicKey;
    static /* synthetic */ Class class$java$security$PrivateKey;

    public abstract String engineGetURI();

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            return this._signatureAlgorithm.verify(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = key.getClass().getName();
            Class clazz = class$java$security$PublicKey;
            if (clazz == null) {
                clazz = class$java$security$PublicKey = SignatureBaseRSA.class$("java.security.PublicKey");
            }
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this._signatureAlgorithm.sign();
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            Class clazz = class$java$security$PrivateKey;
            if (clazz == null) {
                clazz = class$java$security$PrivateKey = SignatureBaseRSA.class$("java.security.PrivateKey");
            }
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            Class clazz = class$java$security$PrivateKey;
            if (clazz == null) {
                clazz = class$java$security$PrivateKey = SignatureBaseRSA.class$("java.security.PrivateKey");
            }
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this._signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._signatureAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnRSA");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._signatureAlgorithm = null;
    }

    public SignatureBaseRSA() throws XMLSignatureException {
        this.this();
        JCEMapper.ProviderIdClass providerIdClass = JCEMapper.translateURItoJCEID(this.engineGetURI());
        cat.debug((Object)("Created SignatureDSA using " + providerIdClass.getAlgorithmID() + ' ' + providerIdClass.getProviderId()));
        try {
            this._signatureAlgorithm = Signature.getInstance(providerIdClass.getAlgorithmID(), providerIdClass.getProviderId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{providerIdClass.getAlgorithmID(), noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{providerIdClass.getProviderId(), noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchProvider", objectArray);
        }
    }

    static {
        Class clazz = class$org$apache$xml$security$algorithms$implementations$SignatureBaseRSA;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$algorithms$implementations$SignatureBaseRSA = SignatureBaseRSA.class$("org.apache.xml.security.algorithms.implementations.SignatureBaseRSA");
        }
        cat = Category.getInstance((String)clazz.getName());
    }

    public static class SignatureRSASHA1
    extends SignatureBaseRSA {
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
    }

    public static class SignatureRSASHA256
    extends SignatureBaseRSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
    }

    public static class SignatureRSASHA384
    extends SignatureBaseRSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        }
    }

    public static class SignatureRSASHA512
    extends SignatureBaseRSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
    }

    public static class SignatureRSARIPEMD160
    extends SignatureBaseRSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
        }
    }

    public static class SignatureRSAMD5
    extends SignatureBaseRSA {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
        }
    }
}

