/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.helper;

import java.util.Arrays;
import java.util.Vector;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.NSAttrCompare;
import org.apache.xml.security.c14n.helper.NonNSAttrCompare;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class C14nHelper {
    public static final Object[] sortAttributes(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray == null) {
            return new Attr[0];
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        int n = 0;
        while (n < objectArray.length) {
            objectArray2 = (Object[])objectArray[n];
            if ("http://www.w3.org/2000/xmlns/".equals(objectArray2.getNamespaceURI())) {
                vector.add(objectArray2);
            } else {
                vector2.add(objectArray2);
            }
            ++n;
        }
        Object[] objectArray3 = vector.toArray();
        Arrays.sort(objectArray3, new NSAttrCompare());
        objectArray2 = vector2.toArray();
        Arrays.sort(objectArray2, new NonNSAttrCompare());
        Object[] objectArray4 = new Object[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray3.length) {
            objectArray4[n2] = (Attr)objectArray3[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < objectArray2.length) {
            objectArray4[n2 + objectArray3.length] = (Attr)objectArray2[n2];
            ++n2;
        }
        return objectArray4;
    }

    public static final String normalizeAttr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\t': {
                    stringBuffer.append("&#x9;");
                    break;
                }
                case '\n': {
                    stringBuffer.append("&#xA;");
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String normalizeComment(String string) {
        return C14nHelper.normalizeProcessingInstruction(string);
    }

    public static final String normalizeProcessingInstruction(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String normalizeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean namespaceIsRelative(Attr attr) {
        return C14nHelper.namespaceIsAbsolute(attr) ^ true;
    }

    public static boolean namespaceIsRelative(String string) {
        return C14nHelper.namespaceIsAbsolute(string) ^ true;
    }

    public static boolean namespaceIsAbsolute(Attr attr) {
        return C14nHelper.namespaceIsAbsolute(attr.getValue());
    }

    public static boolean namespaceIsAbsolute(String string) {
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == ':') {
                bl = true;
            } else if (!bl && c == '/') {
                return false;
            }
            ++n2;
        }
        return bl;
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String string = attr.getNodeName();
        boolean bl = string.equals("xmlns");
        boolean bl2 = string.startsWith("xmlns:");
        if ((bl || bl2) && C14nHelper.namespaceIsRelative(attr)) {
            String string2 = attr.getOwnerElement().getTagName();
            String string3 = attr.getValue();
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
    }

    public static void checkTraversability(Document document) throws CanonicalizationException {
        if (!document.isSupported("Traversal", "2.0")) {
            Object[] objectArray = new Object[]{document.getImplementation().getClass().getName()};
            throw new CanonicalizationException("c14n.Canonicalizer.TraversalNotSupported", objectArray);
        }
    }

    public static void checkForRelativeNamespace(Element element) throws CanonicalizationException {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                C14nHelper.assertNotRelativeNS((Attr)namedNodeMap.item(n));
                ++n;
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }

    private C14nHelper() {
    }
}

