/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    boolean _includeComments;
    Set _xpathNodeSet;
    Document _doc;
    Element _documentElement;
    Node _rootNodeOfC14n;
    Writer _writer;
    Set _inclusiveNSSet;
    HashMap _renderedPrefixesForElement;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeSubTree(Node node) throws CanonicalizationException {
        this._rootNodeOfC14n = node;
        this._doc = XMLUtils.getOwnerDocument(this._rootNodeOfC14n);
        this._documentElement = this._doc.getDocumentElement();
        XMLUtils.circumventBug2650(this._doc);
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this.canonicalizeSubTree(this._rootNodeOfC14n);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var3_6 = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeSubTree(Node node) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.canonicalizeSubTree(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                this.outputTextToWriter(node.getNodeValue());
                break;
            }
            case 1: {
                Element element = (Element)node;
                this._writer.write("<");
                this._writer.write(element.getTagName());
                Object[] objectArray = this.handleAttributesSubtree(element);
                int n = 0;
                while (n < objectArray.length) {
                    this.outputAttrToWriter(((Attr)objectArray[n]).getNodeName(), ((Attr)objectArray[n]).getNodeValue());
                    ++n;
                }
                this._writer.write(">");
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    this.canonicalizeSubTree(node3);
                    node3 = node3.getNextSibling();
                }
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    static int getPositionRelativeToDocumentElement(Node node) {
        if (node == null) {
            return 0;
        }
        Document document = node.getOwnerDocument();
        if (node.getParentNode() != document) {
            return 0;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return 0;
        }
        if (element == node) {
            return 0;
        }
        Node node2 = node;
        while (node2 != null) {
            if (node2 == element) {
                return -1;
            }
            node2 = node2.getNextSibling();
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        Node node = (Node)this._xpathNodeSet.iterator().next();
        this._doc = XMLUtils.getOwnerDocument(node);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this.canonicalizeXPathNodeSet(this._doc);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var4_9 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        if (this._doc == null) {
            Node node = (Node)this._xpathNodeSet.iterator().next();
            this._doc = XMLUtils.getOwnerDocument(node);
            this._documentElement = this._doc.getDocumentElement();
            this._rootNodeOfC14n = this._doc;
        }
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this.canonicalizeXPathNodeSet(this._rootNodeOfC14n);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var3_8 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeXPathNodeSet(Node node) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        boolean bl = this._xpathNodeSet.contains(node);
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.canonicalizeXPathNodeSet(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments || !this._xpathNodeSet.contains(node)) break;
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                if (!this._xpathNodeSet.contains(node)) break;
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                if (!this._xpathNodeSet.contains(node)) break;
                this.outputTextToWriter(node.getNodeValue());
                Node node3 = node.getNextSibling();
                while (node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4)) {
                    this.outputTextToWriter(node3.getNodeValue());
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (bl) {
                    this._writer.write("<");
                    this._writer.write(element.getTagName());
                }
                Object[] objectArray = this.handleAttributes(element);
                objectArray = C14nHelper.sortAttributes(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    Attr attr = (Attr)objectArray[n];
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                    ++n;
                }
                if (bl) {
                    this._writer.write(">");
                }
                Node node4 = node.getFirstChild();
                while (node4 != null) {
                    this.canonicalizeXPathNodeSet(node4);
                    node4 = node4.getNextSibling();
                }
                if (!bl) break;
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    void outputAttrToWriter(String string, String string2) throws IOException {
        this._writer.write(" ");
        this._writer.write(string);
        this._writer.write("=\"");
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '\"': {
                    this._writer.write("&quot;");
                    break;
                }
                case '\t': {
                    this._writer.write("&#x9;");
                    break;
                }
                case '\n': {
                    this._writer.write("&#xA;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        this._writer.write("\"");
    }

    void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        int n;
        this._writer.write("<?");
        String string = processingInstruction.getTarget();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            switch (n) {
                case 13: {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(n);
                }
            }
            ++n3;
        }
        String string2 = processingInstruction.getData();
        n2 = string2.length();
        if (string2 != null && n2 > 0) {
            this._writer.write(" ");
            n = 0;
            while (n < n2) {
                char c = string2.charAt(n);
                switch (c) {
                    case '\r': {
                        this._writer.write("&#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++n;
            }
        }
        this._writer.write("?>");
    }

    void outputCommentToWriter(Comment comment) throws IOException {
        this._writer.write("<!--");
        String string = comment.getData();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        this._writer.write("-->");
    }

    void outputTextToWriter(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '>': {
                    this._writer.write("&gt;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
    }

    abstract Object[] handleAttributes(Element var1) throws CanonicalizationException;

    abstract Object[] handleAttributesSubtree(Element var1) throws CanonicalizationException;

    private final /* synthetic */ void this() {
        this._includeComments = false;
        this._xpathNodeSet = null;
        this._doc = null;
        this._documentElement = null;
        this._rootNodeOfC14n = null;
        this._writer = null;
        this._inclusiveNSSet = null;
        this._renderedPrefixesForElement = null;
    }

    public CanonicalizerBase(boolean bl) {
        this.this();
        this._includeComments = bl;
    }
}

