/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.SecretKey;
import org.apache.log4j.Category;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.ContentHandlerAlreadyRegisteredException;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.MgmtData;
import org.apache.xml.security.keys.content.PGPData;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.content.SPKIData;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KeyInfo
extends SignatureElementProxy {
    static Category cat;
    static boolean _alreadyInitialized;
    Element _dsns;
    Vector _internalKeyResolvers;
    Vector _storageResolvers;
    static /* synthetic */ Class class$org$apache$xml$security$keys$KeyInfo;

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String string) {
        this.add(new KeyName(this._doc, string));
    }

    public void add(KeyName keyName) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyName.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addKeyValue(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void addKeyValue(Element element) {
        this.add(new KeyValue(this._doc, element));
    }

    public void add(DSAKeyValue dSAKeyValue) {
        this.add(new KeyValue(this._doc, dSAKeyValue));
    }

    public void add(RSAKeyValue rSAKeyValue) {
        this.add(new KeyValue(this._doc, rSAKeyValue));
    }

    public void add(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void add(KeyValue keyValue) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyValue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addMgmtData(String string) {
        this.add(new MgmtData(this._doc, string));
    }

    public void add(MgmtData mgmtData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(mgmtData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(PGPData pGPData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(pGPData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addRetrievalMethod(String string, Transforms transforms, String string2) {
        this.add(new RetrievalMethod(this._doc, string, transforms, string2));
    }

    public void add(RetrievalMethod retrievalMethod) {
        if (this._state == 0) {
            this._constructionElement.appendChild(retrievalMethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(SPKIData sPKIData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(sPKIData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(X509Data x509Data) throws XMLSecurityException {
        if (this._state == 0) {
            this._constructionElement.appendChild(x509Data.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addUnknownElement(Element element) {
        if (this._state == 0) {
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthUnknownElement() {
        int n = 0;
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public KeyName itemKeyName(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "KeyName");
        if (element != null) {
            return new KeyName(element, this._baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        if (element != null) {
            return new KeyValue(element, this._baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "MgmtData");
        if (element != null) {
            return new MgmtData(element, this._baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "PGPData");
        if (element != null) {
            return new PGPData(element, this._baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
        if (element != null) {
            return new RetrievalMethod(element, this._baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "SPKIData");
        if (element != null) {
            return new SPKIData(element, this._baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int n) throws XMLSecurityException {
        Element element = this.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "X509Data");
        if (element != null) {
            return new X509Data(element, this._baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = 0;
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && ++n2 == n) {
                return (Element)node;
            }
            ++n3;
        }
        return null;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this._constructionElement.getChildNodes().getLength() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsKeyName() {
        boolean bl = false;
        if (this.lengthKeyName() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsKeyValue() {
        boolean bl = false;
        if (this.lengthKeyValue() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsMgmtData() {
        boolean bl = false;
        if (this.lengthMgmtData() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsPGPData() {
        boolean bl = false;
        if (this.lengthPGPData() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsRetrievalMethod() {
        boolean bl = false;
        if (this.lengthRetrievalMethod() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsSPKIData() {
        boolean bl = false;
        if (this.lengthSPKIData() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsUnknownElement() {
        boolean bl = false;
        if (this.lengthUnknownElement() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsX509Data() {
        boolean bl = false;
        if (this.lengthX509Data() > 0) {
            bl = true;
        }
        return bl;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        return null;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey publicKey = this.getPublicKeyFromInternalResolvers();
        if (publicKey != null) {
            cat.debug((Object)"I could find a key using the per-KeyInfo key resolvers");
            return publicKey;
        }
        cat.debug((Object)"I couldn't find a key using the per-KeyInfo key resolvers");
        publicKey = this.getPublicKeyFromStaticResolvers();
        if (publicKey != null) {
            cat.debug((Object)"I could find a key using the system-wide key resolvers");
            return publicKey;
        }
        cat.debug((Object)"I couldn't find a key using the system-wide key resolvers");
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        int n = 0;
        while (n < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(n);
            int n2 = 0;
            while (n2 < this._constructionElement.getChildNodes().getLength()) {
                Node node = this._constructionElement.getChildNodes().item(n2);
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolver.resolvePublicKey((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 < this._storageResolvers.size()) {
                            PublicKey publicKey;
                            object = (StorageResolver)this._storageResolvers.elementAt(n3);
                            if (keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (publicKey = keyResolver.resolvePublicKey((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return publicKey;
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        int n = 0;
        while (n < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(n);
            cat.debug((Object)("Try " + keyResolverSpi.getClass().getName()));
            int n2 = 0;
            while (n2 < this._constructionElement.getChildNodes().getLength()) {
                Node node = this._constructionElement.getChildNodes().item(n2);
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolverSpi.engineResolvePublicKey((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 < this._storageResolvers.size()) {
                            PublicKey publicKey;
                            object = (StorageResolver)this._storageResolvers.elementAt(n3);
                            if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (publicKey = keyResolverSpi.engineResolvePublicKey((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return publicKey;
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate x509Certificate = this.getX509CertificateFromInternalResolvers();
        if (x509Certificate != null) {
            cat.debug((Object)"I could find a X509Certificate using the per-KeyInfo key resolvers");
            return x509Certificate;
        }
        cat.debug((Object)"I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        x509Certificate = this.getX509CertificateFromStaticResolvers();
        if (x509Certificate != null) {
            cat.debug((Object)"I could find a X509Certificate using the system-wide key resolvers");
            return x509Certificate;
        }
        cat.debug((Object)"I couldn't find a X509Certificate using the system-wide key resolvers");
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        cat.debug((Object)("Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers"));
        int n = 0;
        while (n < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(n);
            int n2 = 0;
            while (n2 < this._constructionElement.getChildNodes().getLength()) {
                Node node = this._constructionElement.getChildNodes().item(n2);
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolver.resolveX509Certificate((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 < this._storageResolvers.size()) {
                            X509Certificate x509Certificate;
                            object = (StorageResolver)this._storageResolvers.elementAt(n3);
                            if (keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (x509Certificate = keyResolver.resolveX509Certificate((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return x509Certificate;
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        cat.debug((Object)("Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers"));
        int n = 0;
        while (n < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(n);
            cat.debug((Object)("Try " + keyResolverSpi.getClass().getName()));
            int n2 = 0;
            while (n2 < this._constructionElement.getChildNodes().getLength()) {
                Node node = this._constructionElement.getChildNodes().item(n2);
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolverSpi.engineResolveX509Certificate((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n3 = 0;
                        while (n3 < this._storageResolvers.size()) {
                            X509Certificate x509Certificate;
                            object = (StorageResolver)this._storageResolvers.elementAt(n3);
                            if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (x509Certificate = keyResolverSpi.engineResolveX509Certificate((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return x509Certificate;
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        this._internalKeyResolvers.add(keyResolverSpi);
    }

    int lengthInternalKeyResolver() {
        return this._internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int n) {
        return (KeyResolverSpi)this._internalKeyResolvers.elementAt(n);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (storageResolver != null) {
            this._storageResolvers.add(storageResolver);
        }
    }

    Vector getStorageResolvers() {
        return this._storageResolvers;
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (cat == null) {
                Class clazz = class$org$apache$xml$security$keys$KeyInfo;
                if (clazz == null) {
                    clazz = class$org$apache$xml$security$keys$KeyInfo = KeyInfo.class$("org.apache.xml.security.keys.KeyInfo");
                }
                cat = Category.getInstance((String)clazz.getName());
                cat.error((Object)"Had to assign cat in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public static void registerKeyInfoContentHandler(String string, String string2, String string3) throws ContentHandlerAlreadyRegisteredException {
        Init.registerKeyInfoContentHandler(string, string2, string3);
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._dsns = null;
        this._internalKeyResolvers = new Vector();
        this._storageResolvers = new Vector();
    }

    public KeyInfo(Document document) {
        super(document);
        this.this();
        XMLUtils.addReturnToElement(this._constructionElement);
        this._dsns = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    public KeyInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
        this.this();
        this._dsns = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    static {
        Class clazz = class$org$apache$xml$security$keys$KeyInfo;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$keys$KeyInfo = KeyInfo.class$("org.apache.xml.security.keys.KeyInfo");
        }
        cat = Category.getInstance((String)clazz.getName());
        _alreadyInitialized = false;
    }
}

