/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSAKeyValueResolver
extends KeyResolverSpi {
    private Element _dsaKeyElement;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (element == null) {
            return false;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "DSAKeyValue");
        if (bl) {
            try {
                Element element2 = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
                this._dsaKeyElement = (Element)XPathAPI.selectSingleNode((Node)element, (String)"./ds:DSAKeyValue", (Node)element2);
                if (this._dsaKeyElement != null) {
                    return true;
                }
            }
            catch (TransformerException transformerException) {}
        } else if (bl2) {
            this._dsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        boolean bl;
        if (!(this._dsaKeyElement != null || (bl = this.engineCanResolve(element, string, storageResolver)) && this._dsaKeyElement != null)) {
            return null;
        }
        try {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(this._dsaKeyElement, string);
            PublicKey publicKey = dSAKeyValue.getPublicKey();
            return publicKey;
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    private final /* synthetic */ void this() {
        this._dsaKeyElement = null;
    }

    public DSAKeyValueResolver() {
        this.this();
    }
}

