/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.provider;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.provider.CertificateElement;
import org.apache.xml.security.keys.provider.KeyElement;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class KeyStoreElement
extends ElementProxy {
    public String getBaseLocalName() {
        return "KeyStore";
    }

    public String getBaseNamespace() {
        return "http://xml.apache.org/security/#KeyStore";
    }

    protected void removeOldSignatures() {
        Element element = null;
        while ((element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "Signature")) != null) {
            if (element == null) continue;
            Node node = element.getParentNode();
            Node node2 = element.getNextSibling();
            if (node2 != null && node2.getNodeType() == 3 && ((Text)node2).getData().equals("\n")) {
                node.removeChild(node2);
            }
            node.removeChild(element);
        }
    }

    public void sign(char[] cArray) throws IOException {
        try {
            this.removeOldSignatures();
            XMLSignature xMLSignature = new XMLSignature(this._doc, "", "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            this._constructionElement.appendChild(xMLSignature.getElement());
            XMLUtils.addReturnToElement(this);
            Transforms transforms = new Transforms(this._doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            xMLSignature.addDocument("", transforms);
            SecretKey secretKey = KeyStoreElement.generateKeyFromPass(xMLSignature, cArray);
            xMLSignature.sign(secretKey);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new IOException(xMLSignatureException.getMessage());
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new IOException(xMLSecurityException.getMessage());
        }
    }

    public Element getSignatureElement() throws XMLSecurityException {
        NodeList nodeList = this._doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        throw new XMLSecurityException("empty");
    }

    public boolean verify(char[] cArray) throws IOException {
        try {
            Element element = this.getSignatureElement();
            if (element == null) {
                throw new IOException("There must be exactly one ds:Signature in the KeyStore");
            }
            XMLSignature xMLSignature = new XMLSignature(element, "memory://");
            if (xMLSignature.getSignedInfo().getLength() != 1) {
                throw new IOException("ds:Signature/ds:getSignedInfo must contain exactly one ds:Reference but it was " + xMLSignature.getSignedInfo().getLength());
            }
            Reference reference = xMLSignature.getSignedInfo().item(0);
            if (!reference.getURI().equals("")) {
                throw new IOException("ds:Reference/@URI!=\"\"");
            }
            Transforms transforms = reference.getTransforms();
            if (transforms == null || transforms.getLength() != 1) {
                throw new IOException("There must be exactly one EnvelopedSignature Transform");
            }
            Transform transform = transforms.item(0);
            if (!transform.getURI().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                throw new IOException("There must be exactly one EnvelopedSignature Transform");
            }
            SecretKey secretKey = KeyStoreElement.generateKeyFromPass(xMLSignature, cArray);
            return xMLSignature.checkSignatureValue(secretKey);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new IOException(xMLSignatureException.getMessage());
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new IOException(xMLSecurityException.getMessage());
        }
    }

    private static final SecretKey generateKeyFromPass(XMLSignature xMLSignature, char[] cArray) throws XMLSecurityException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        return xMLSignature.createSecretKey(stringBuffer.toString().getBytes());
    }

    public int getNumberOfKeys() {
        return this.length("http://xml.apache.org/security/#KeyStore", "Key");
    }

    public int getNumberOfCertificates() {
        return this.length("http://xml.apache.org/security/#KeyStore", "Certificate");
    }

    public Enumeration aliases() {
        try {
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            Element element = this._doc.createElementNS(null, "nsctx");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "http://xml.apache.org/security/#KeyStore");
            NodeList nodeList = cachedXPathAPI.selectNodeList((Node)this._doc, "/x:KeyStore/x:*/x:Alias/text()", (Node)element);
            Vector<String> vector = new Vector<String>(nodeList.getLength());
            int n = 0;
            while (n < nodeList.getLength()) {
                Text text = (Text)nodeList.item(n);
                vector.add(text.getNodeValue());
                ++n;
            }
            return new MyEnumeration(vector);
        }
        catch (TransformerException transformerException) {
            return new MyEnumeration(new Vector());
        }
    }

    public boolean isCertificateEntry(String string) {
        Element element = this.getCertificateEntryElement(string);
        boolean bl = false;
        if (element != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isKeyEntry(String string) {
        Element element = this.getKeyEntryElement(string);
        boolean bl = false;
        if (element != null) {
            bl = true;
        }
        return bl;
    }

    public Element getCertificateEntryElement(String string) {
        try {
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            Element element = this._doc.createElementNS(null, "nsctx");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "http://xml.apache.org/security/#KeyStore");
            String string2 = "/x:KeyStore/x:Certificate[./x:Alias/text()=\"" + string + "\"]";
            NodeList nodeList = cachedXPathAPI.selectNodeList((Node)this._doc, string2, (Node)element);
            if (nodeList.getLength() == 1) {
                return (Element)nodeList.item(0);
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return null;
    }

    public Element getKeyEntryElement(String string) {
        try {
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            Element element = this._doc.createElementNS(null, "nsctx");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "http://xml.apache.org/security/#KeyStore");
            String string2 = "/x:KeyStore/x:Key[./x:Alias/text()=\"" + string + "\"]";
            NodeList nodeList = cachedXPathAPI.selectNodeList((Node)this._doc, string2, (Node)element);
            if (nodeList.getLength() == 1) {
                return (Element)nodeList.item(0);
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return null;
    }

    public Certificate getCertificate(String string) {
        try {
            Element element = this.getCertificateEntryElement(string);
            if (element == null) {
                return null;
            }
            CertificateElement certificateElement = new CertificateElement(element, this._baseURI);
            return certificateElement.getCertificate();
        }
        catch (CertificateException certificateException) {
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public Date getCreationDate(String string) {
        try {
            Element element = this.getCertificateEntryElement(string);
            if (element != null) {
                CertificateElement certificateElement = new CertificateElement(element, this._baseURI);
                return certificateElement.getDate();
            }
            Element element2 = this.getKeyEntryElement(string);
            if (element2 != null) {
                KeyElement keyElement = new KeyElement(element2, this._baseURI);
                return keyElement.getDate();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            // empty catch block
        }
        return null;
    }

    public void deleteEntry(String string) throws KeyStoreException {
        Node node;
        Node node2;
        Element element = this.getKeyEntryElement(string);
        if (element != null) {
            node2 = element.getParentNode();
            node = element.getNextSibling();
            if (node != null && node.getNodeType() == 3 && ((Text)node).getData().equals("\n")) {
                node2.removeChild(node);
            }
            node2.removeChild(element);
        }
        if ((element = this.getCertificateEntryElement(string)) != null) {
            node2 = element.getParentNode();
            node = element.getNextSibling();
            if (node != null && node.getNodeType() == 3 && ((Text)node).getData().equals("\n")) {
                node2.removeChild(node);
            }
            node2.removeChild(element);
        }
    }

    public Certificate[] getCertificateChain(String string) {
        try {
            Element element = this.getKeyEntryElement(string);
            if (element != null) {
                KeyElement keyElement = new KeyElement(element, this._baseURI);
                return keyElement.getCertificateChain(string);
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            xMLSecurityException.printStackTrace();
        }
        return new Certificate[0];
    }

    public void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        try {
            CertificateElement certificateElement = new CertificateElement(this._doc, string, certificate);
            this._constructionElement.appendChild(certificateElement.getElement());
            XMLUtils.addReturnToElement(this);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyStoreException(xMLSecurityException.getMessage());
        }
    }

    public void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            KeyElement keyElement = new KeyElement(this._doc, string, byArray, certificateArray);
            this._constructionElement.appendChild(keyElement.getElement());
            XMLUtils.addReturnToElement(this);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyStoreException(xMLSecurityException.getMessage());
        }
    }

    public void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            KeyElement keyElement = new KeyElement(this._doc, string, key, cArray, certificateArray);
            this._constructionElement.appendChild(keyElement.getElement());
            XMLUtils.addReturnToElement(this);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyStoreException(xMLSecurityException.getMessage());
        }
    }

    public Key getKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            KeyElement keyElement = new KeyElement(this.getKeyEntryElement(string), this._baseURI);
            return keyElement.unwrap(cArray);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new UnrecoverableKeyException(xMLSecurityException.getMessage());
        }
    }

    public KeyStoreElement(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this);
    }

    public KeyStoreElement(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public class MyEnumeration
    implements Enumeration {
        Vector _v;
        int _i;

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this._i < this._v.size()) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this._v.elementAt(this._i++);
            }
            return null;
        }

        protected MyEnumeration(Vector vector) {
            this._v = vector;
            this._i = 0;
        }
    }
}

