/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage.implementations;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.storage.StorageResolverException;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.utils.Base64;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KeyStoreResolver
extends StorageResolverSpi {
    KeyStore _keyStore;
    Iterator _iterator;

    public Iterator getIterator() {
        return this._iterator;
    }

    public static void main(String[] stringArray) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(new FileInputStream("data/org/apache/xml/security/samples/input/keystore.jks"), "xmlsecurity".toCharArray());
        KeyStoreResolver keyStoreResolver = new KeyStoreResolver(keyStore);
        Iterator iterator = keyStoreResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            byte[] byArray = XMLX509SKI.getSKIBytesFromCert(x509Certificate);
            System.out.println(Base64.encode(byArray));
        }
    }

    private final /* synthetic */ void this() {
        this._keyStore = null;
        this._iterator = null;
    }

    public KeyStoreResolver(KeyStore keyStore) throws StorageResolverException {
        this.this();
        this._keyStore = keyStore;
        this._iterator = new KeyStoreIterator(this, this._keyStore);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class KeyStoreIterator
    implements Iterator {
        KeyStore _keyStore;
        Enumeration _aliases;

        public boolean hasNext() {
            return this._aliases.hasMoreElements();
        }

        public Object next() {
            String string = (String)this._aliases.nextElement();
            try {
                return this._keyStore.getCertificate(string);
            }
            catch (KeyStoreException keyStoreException) {
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }

        private final /* synthetic */ void this() {
            this._keyStore = null;
            this._aliases = null;
        }

        public KeyStoreIterator(KeyStoreResolver keyStoreResolver2, KeyStore keyStore) throws StorageResolverException {
            this.this();
            try {
                this._keyStore = keyStore;
                this._aliases = this._keyStore.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                throw new StorageResolverException("generic.EmptyMessage", keyStoreException);
            }
        }
    }
}

