/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/19 14:13:34 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.apm;

/**
*	The generic <code>PerformanceModel</code> interface is used to provide an
*	interface for the QoS Management module to estimate appropriate runtimes
*	etc based on a concrete machine specific application performance model.
*	<p>
*	Each native application has to provide an implementation of this interface
*	in order to enable QoS support for the application service. Each
*	implementation will be machine and application specific.
*
*	@author		Gerhard Engelbrecht
*/
public interface PerformanceModel {

	/**
	*	Returns estimations in a Performance Descriptor based on the given meta
	*	information in the Request Descriptor and the Machine Descriptor. All 
	*	descirptors are represented at this level as an XML document in a 
	*	String.
	*	<p>
	*	The returned Performance Descriptor contains estimations on the 
	*	runtime, the disc requirements and the memory requirements of the
	*	specified job on a specific machine. 
	*
	*	@param		reqDesc given Request Descriptor, containing request 
	*				specific information about the job (e.g. mesh size, image
	*				resolution)
	*	@param		machineDesc given Machine Descriptor containing machine 
	*				specific information (e.g. number of computing nodes). 
	*
	*	@return		A Performance Descriptor containing estimations on the
	*				runtime, the disc requirements and the memory requirements
	*				of the specified job on a specific machine.
	*/
    public String getPerformanceEstimate(String reqDesc, String machineDesc);
}
