/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/19 14:13:34 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.apm;

/**
*	Factory class for providing appropriate <code>PerformanceModel</code> 
*	implementations.
*
*	@author	Gerhard Engelbrecht
*
*	@see	at.ac.univie.iss.bm.BusinessModel
*/
public class PerformanceModelFactory {

	private static PerformanceModelFactory factory = null;
	
	private PerformanceModelFactory() {
	}
	
	/**
	*	Returns a <code>PerformanceModelFactory</code> singleton object.
	*/
	final static public PerformanceModelFactory getInstance() {
	
		if (factory == null) {
		
			factory = new PerformanceModelFactory();
		}
		
		return factory;
	}
	
	/**
	*	Returns a concrete <code>PerformanceModel</code> instance based on the
	*	given machine specific performance model name.
	*
	*	@param		performanceModelName class name (incl. package name) of the
	*				concrete machine specific application performance model 
	*				implementation class.
	*
	*	@return		concrete <code>PerformanceModel</code> instance
	*
	*	@throws		Exception if the creation of the <code>PerformanceModel
	*				</code> instance failed (e.g. class could no be found).
	*/
    final public PerformanceModel getPerformanceModel(String performanceModelName) throws Exception {
    
    	ClassLoader cl = this.getClass().getClassLoader();
    	
    	Class perfModelClass = cl.loadClass(performanceModelName);
    	
    	PerformanceModel perfModel = (PerformanceModel) perfModelClass.newInstance();
    	
    	return perfModel;
    }
}
