/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/05/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/06/24 13:17:05 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.apm.test;

import at.ac.univie.iss.apm.PerformanceModel;

public class DummyPerformanceModel implements PerformanceModel {

	public DummyPerformanceModel() {
	}

    public String getPerformanceEstimate(String reqDesc, String machineDesc) {
    
		int first = machineDesc.indexOf("<number-of-nodes>");
		
		String submachineDesc = machineDesc.substring((new String("<number-of-nodes>").length()) + first);
		String number = submachineDesc.substring(0, submachineDesc.indexOf("</")).trim();
		
		int nodes = Integer.parseInt(number); 
		
		int runtime = (int)(10000 / nodes);

		StringBuffer perfDesc = new StringBuffer();
		
		perfDesc.append("<PerformanceDescriptor>\n");
	
		perfDesc.append("	<Runtime>" + runtime + "</Runtime>\n");
		perfDesc.append("	<DiscRequirement>10</DiscRequirement>\n");
		perfDesc.append("	<MemoryRequirement>200</MemoryRequirement>\n");
	
		perfDesc.append("</PerformanceDescriptor>\n");
		
        return perfDesc.toString();
    	
    }
}
