/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/18 21:06:37 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////
package at.ac.univie.iss.bm;

import java.util.Calendar;

/**
*	The generic <code>BusinessModel</code> interface is used to provide an
*	interface for the QoS Management module to calculate appropriate prices
*	based on concrete business model implementations.<p>
*	In order to provide a specific business model (e.g. simple pay per use)
*	for a QoS-enabled application service, this interface has to be
*	implemented by a concrete class and this class has to be packaged up in
*	the service war-file. The concrete implementation class name and package
*	has to be specified in the application descriptor.
*
*	@author		Gerhard Engelbrecht
*/
public interface BusinessModel {

	/**
	*	Returns the price for the resource based on the begin and and of usage
	*	as well as the number of nodes.
	*	
	*	@param		begin begin time of resource usage
	*	@param		end end time of resource usage
	*	@param		numberOfNodes number of nodes 
	*	
	*	@return		calculated price
	*/
    public double getPrice(Calendar begin, Calendar end, int numberOfNodes);
    // public double getPrice2(Reservation res);
    // public Reservation[] sort(Reservation res[]);
    // public Reservation[] getTimeFrame(long execTime, Date begin, Date end, int numOfCPUs, long expTime, double price);

}	

