/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/19 14:11:43 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.bm;

/**
*	Factory class for providing appropriate <code>BusinessModel</code> 
*	implementations.
*
*	@author	Gerhard Engelbrecht
*
*	@see	at.ac.univie.iss.bm.BusinessModel
*/
public class BusinessModelFactory {

	private static BusinessModelFactory factory = null;
	
	private BusinessModelFactory() {
	}
	
	/**
	*	Returns a <code>BusinessModelFactory</code> singleton object.
	*/
	final static public BusinessModelFactory getInstance() {
	
		if (factory == null) {
		
			factory = new BusinessModelFactory();
		}
		
		return factory;
	}
	
	/**
	*	Returns a concrete <code>BusinessModel</code> instance based on the
	*	given business model name.
	*
	*	@param		businessModelName class name (incl. package name) of the 
	*				concrete business model implementation class.
	*
	*	@return		concrete <code>BusinessModel</code> instance
	*
	*	@throws		Exception if the creation of the <code>BusinessModel</code>
	*				instance failed (e.g. class could no be found).
	*/
    final public BusinessModel getBusinessModel(String businessModelName) throws Exception {
    
    	ClassLoader cl = this.getClass().getClassLoader();
    	
    	Class bmClass = cl.loadClass(businessModelName);
    	
    	BusinessModel bm = (BusinessModel) bmClass.newInstance();
    	
    	return bm;
    }
}
