/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/06/30 21:56:52 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.common.logging;

import java.util.logging.*;
import java.util.*;
import java.text.SimpleDateFormat;

public class LoggingFormatter extends java.util.logging.Formatter {

    private SimpleDateFormat dateAndTimeFormatter = new SimpleDateFormat("dd/MM/yy HH:mm:ss"); 

	public String format(LogRecord record) {
	
		//02/02/04 16:01:28 DEBUG [AppHandlerImpl.downloadString] - 1075734081101-83 - F
		
		String date = dateAndTimeFormatter.format(new Date(record.getMillis()));
		String sourceClassName = record.getSourceClassName();
		
		int lastDotPos = sourceClassName.lastIndexOf(".");
		
		String finalSourceClassName = (lastDotPos >= 0) ? sourceClassName.substring(lastDotPos + 1) : sourceClassName;

		if (record.getThrown() == null) {
			
			if ((record.getMessage() != null) && (record.getMessage().length() > 0) && 
				(record.getMessage().substring(record.getMessage().length() - 1).equals("\n"))) {

					return (new String(date + " " + record.getLevel() + " [" + finalSourceClassName + 
						"." + record.getSourceMethodName() + "] - " + record.getMessage()));
			}
			else {
				return (new String(date + " " + record.getLevel() + " [" + finalSourceClassName + 
					"." + record.getSourceMethodName() + "] - " + record.getMessage() + "\n"));
			}
		}
		else {
			Throwable throwable = record.getThrown();
			
			StringBuffer buffer = new StringBuffer();
			if ((record.getMessage() != null) && (record.getMessage().length() > 0) && 
				(record.getMessage().substring(record.getMessage().length() - 1).equals("\n"))) {
		
					buffer.append(new String(date + " " + record.getLevel() + " [" + finalSourceClassName + 
						"." + record.getSourceMethodName() + "] - " + record.getMessage()));
			}
			else {
				buffer.append(new String(date + " " + record.getLevel() + " [" + finalSourceClassName + 
					"." + record.getSourceMethodName() + "] - " + record.getMessage()) + "\n");
			}			
			
			if (throwable.getMessage() != null) {
				buffer.append(throwable.getMessage() + "\n");
			}
			else {
				buffer.append(throwable + "\n");
			}
			
			for (int count = 0; count < throwable.getStackTrace().length; count++) {
				
				buffer.append("\t" + throwable.getStackTrace()[count].toString() + "\n");
			}				
			return buffer.toString();
		}
		
		
	}
	/*
	
27/06/04 20:25:15 SEVERE [DetailsRepository.removeDetails] - An error occured (see details below).
null
	sun.nio.ch.FileChannelImpl.lock(FileChannelImpl.java:739)
	java.nio.channels.FileChannel.lock(FileChannel.java:865)
	at.ac.univie.iss.service.state.DetailsRepository.removeDetails(DetailsRepository.java:158)
	at.ac.univie.iss.test.TestDetailsRepository$TestThread.run(TestDetailsRepository.java:118)	
	
	public String formatMessage(LogRecord record) {
	
		return format(record);
	
	}

	public String getHead(Handler h) {
	
		return null;
	}
	
	public String getTail(Handler h) {
	
		return null;
	}
	*/
}