/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004 and
//     C&C Research Laboratories, NEC Europe Ltd.
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
// and C&C Research Laboratories, NEC Europe Ltd, Rathausallee 10
// 53757 Sankt Augustin, Germany
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Falk Zimmermann, Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:11:39 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.crm;

import java.util.Date;

public interface ComputeResourceManager {

	/**
	*	Returns a job id for the required temporary reservation based on the
	*	given input.
	*/
	public long getTempReservation(int nodes,int minutes, Date start, Date stop, Date validity) throws Exception;

	/**
	*	Returns true if the reservation with the given job id could be
	*	confirmed.
	*/
	public boolean confirmReservation(long jobId) throws Exception;

	/**
	*	Returns true if the reservation with the given job id could be
	*	canceled.
	*/
	public boolean cancelReservation(long jobId) throws Exception;

	/**
	*	Returns true if the given job scripted could be inserted for the
	*	given job id.
	*/
	public boolean insertBatchScript(long jobId, String script) throws Exception;

	/**
	*	Returns a job id for the required time and number of nodes.
	*/
	public long makeSubmission(int nodes, int minutes, String script) throws Exception;

	/**
	*	Returns all available job information for the given job id.
	*/
	public JobInfo getJobInfo(long jobId) throws Exception;
}


