/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004 and
//     C&C Research Laboratories, NEC Europe Ltd.
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
// and C&C Research Laboratories, NEC Europe Ltd, Rathausallee 10
// 53757 Sankt Augustin, Germany
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Falk Zimmermann, Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/09/14 15:31:03 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.crm;

import java.util.Date;

public class JobInfo {

    public long jobId;
    public String user;
    public int status;
    public int numNodes;
    public int confirm;
    public Date startTime;
    public Date endTime;
    public Date expirationTime;
   
    public String statusInfo[] =
    { "Queued" , "Rejected", "Waiting",  "Scheduled",
      "Running", "Finalized", "Released", "UNKNOWN", "ERROR" };

    public JobInfo() {
	    jobId = -1;
	    user = "testbed";
	    status = 7;
	    numNodes = -1;
	    confirm = -1;
    }

	public String toString() {
		
		StringBuffer jobInfoString = new StringBuffer();
		jobInfoString.append("[job-info - jid: " + jobId);
		if ((status >= 0) && (status <= 7)) {
			jobInfoString.append(", Status: " + statusInfo[status]);
		}
		else {
			jobInfoString.append(", Status: " + status);
		}
		jobInfoString.append(", NumOfNodes: " + numNodes + ", Start: " + startTime + ", End: " + endTime);
		jobInfoString.append(" Confirm: " + confirm);
		jobInfoString.append("]");
	
		return jobInfoString.toString();
	}
}