//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/11/05
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/11/23 15:31:03 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.crm.maui;


import at.ac.univie.iss.crm.JobInfo;
import java.util.Date;


public class MAUIJobInfo extends JobInfo {

    public long qsubJobId;
    public String workingDir;
    public String MauiReservationID;

    public MAUIJobInfo() {
        super();
        qsubJobId = -1;
        workingDir = null;
        MauiReservationID = null;
    }

    public String toString() {

        StringBuffer jobInfoString = new StringBuffer();

        jobInfoString.append(
                "[job-info - jid: " + jobId + ", qsubId: " + qsubJobId + ", mauiResID: " + MauiReservationID);
        if ((status >= 0) && (status <= 8)) {
            jobInfoString.append(", Status: " + statusInfo[status]);
        } else {
            jobInfoString.append(", Status: " + status);
        }
        jobInfoString.append(", NumOfNodes: " + numNodes + ", Start: " + startTime + ", End: " + endTime);
        jobInfoString.append(" Confirm: " + confirm);
        jobInfoString.append("]");

        return jobInfoString.toString();
    }
}
