/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/11/05
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/11/05 15:31:03 $
//					$Revision: 1.0 $
//
/////////////////////////////////////////////////////////////////////////
package at.ac.univie.iss.crm.maui.util;


import at.ac.univie.iss.crm.maui.MAUIJobInfo;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;


public class MauiDB {
    private static Hashtable reservations = new Hashtable();
    ;
    private static Hashtable canceledReservations = new Hashtable();

    private static Logger logger = Logger.getLogger("at.ac.univie.iss.crm.maui.util.MauiDB");

    public static synchronized MAUIJobInfo dbHandling(String cmd, long jobId, MAUIJobInfo jobInfo) throws Exception {

        if (cmd.equals("put")) {

            if (jobInfo == null) {

                logger.log(Level.WARNING, "The job is not saved in CRM DB. JobInfo can not be null");

                return null;
            }
            reservations.remove(new Long(jobInfo.jobId));
            reservations.put(new Long(jobInfo.jobId), jobInfo);
            return null;
        } else if (cmd.equals("remove")) {

            MAUIJobInfo dbJobInfo = (MAUIJobInfo) reservations.remove(new Long(jobId));

            if (dbJobInfo != null) {
                canceledReservations.put(new Long(jobId), dbJobInfo);
            }
            return dbJobInfo;

        } else if (cmd.equals("get")) {

            return (MAUIJobInfo) reservations.get(new Long(jobId));
        } else if (cmd.equals("getInfo")) {

            StringBuffer logMsg = new StringBuffer();

            logMsg.append("CRM DB (reservations):\n");

            Iterator res = reservations.entrySet().iterator();

            while (res.hasNext()) {
                logMsg.append(res.next() + "\n");
            }

            logMsg.append("CRM DB (removed reservations):\n");

            Iterator cres = canceledReservations.entrySet().iterator();

            while (cres.hasNext()) {
                logMsg.append(cres.next() + "\n");
            }

            logger.log(Level.FINEST, logMsg.toString());
        }
        return null;
    }

}
