//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/11/05
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/11/23 15:31:03 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.crm.samples;


import at.ac.univie.iss.crm.maui.MauiCRMImpl;
import at.ac.univie.iss.crm.JobInfo;

import java.io.*;
import java.util.Date;


public class SampleMAUIUsage {

    public SampleMAUIUsage() {
        try {
            MauiCRMImpl mauiCRMImpl = new MauiCRMImpl();

            int minutes = 15;
            int waitSeconds = 10;

             long id = mauiCRMImpl.getTempReservation(1, 15,
                    new Date(System.currentTimeMillis() + 60000*3 ) ,
                    new Date(System.currentTimeMillis() + 60000*4 + 15000 + 60000 * minutes),
                    new Date(System.currentTimeMillis() ));



            mauiCRMImpl.confirmReservation(id);

            mauiCRMImpl.insertBatchScript(id,
                    "test/runMaui.sh /home/terziev/project/maui/test inputFile outputFile finishFile");

         // long   id1 = mauiCRMImpl.makeSubmission(1, 100,
         //    "test/runMaui.sh /home/terziev/project/maui/test inputFile outputFile finishFile");

            System.out.println(" Press Ctrl+C to exit!");
            try {

                 JobInfo jobInfo;
                do {
                    jobInfo = mauiCRMImpl.getJobInfo(id);

                    System.out.println("=====================");
                    System.out.println("CurentTime: " + new Date(System.currentTimeMillis()));
                    System.out.println("jobInfo : " + jobInfo.toString());

                    Thread.currentThread().sleep(1000 * waitSeconds);
                } while (jobInfo.status != 6);

            } catch (Exception e) {
                System.out.println("SampleMAUIUsage: ERROR : " + e.toString());
            }

            /*
             id = mauiCRMImpl.getTempReservation(1, 4, new Date(System.currentTimeMillis() + 5000),
             new Date(System.currentTimeMillis() + 10000000), new Date(System.currentTimeMillis() + 10000));
             mauiCRMImpl.confirmReservation(id);
             mauiCRMImpl.insertBatchScript(id, "test/runMaui.sh /home/terziev/project/maui/test inputFile outputFile finishFile");
             mauiCRMImpl.insertBatchScript(id, "test/runMaui.sh /home/terziev/project/maui/test inputFile outputFile finishFile");
             */
        } catch (Exception e) {

            System.out.println(" Exception " + e.toString());
        }
    }

    public static void main(String args[]) {

        new SampleMAUIUsage();
    }

}
