/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$$Author: terziev $
//					$Date: 2004/07/22 13:54:34 $
//					$Revision: 1.5 $
//
///////////////////////////////////////////////////////////////////////// 

package at.ac.univie.iss.descriptors;

/**
 *	The interface <code>ApplicationDescriptor</code> provides an API to access
 *	the information of an application descriptor in Java. The implementation 
 *	of this interface is automatically generated from the application 
 *	descriptor's scheme based on Sun'ss Java API for XML Binding (JAXB)
 *	is used. 
 *
 *	@author Gerhard Engelbrecht
 *	@author Nikolay Terziev
 */
public interface ApplicationDescriptor {

      /**
     *	Returns the name of this application descriptor. 
     */
    public String getInfoName();
    
    /**
     *	Sets the name of this application descriptor. 
     */
    public void setInfoName(String infoName) throws Exception;
    
    /**
     *	Returns service-side working directory.
     *
     *	@return working directory
     */
    public String getWorkingDirectory();
    
     /**
     *	Sets the service-side working directory. 
     */
    public void setWorkingDirectory(String workingDirectory) throws Exception;
	
    /**
     *	Returns service-side filename of the input file.
     *
     *	@return filename of the input file
     */
    public String getInputFileName();
    
     /**
     *	Sets the service-side filename of the input file. 
     */
    public void setInputFileName(String inputFile) throws Exception;
	
    /**
     *	Returns service-side filename of the output file.
     *
     *	@return filename of the output file
     */
    public String getOutputFileName();
    
     /**
     *	Returns array from all filenames of the output file. 
     */
    public String[] getOutputFileNames();
    
     /**
     *	Sets the service-side filename of the output file. 
     */
    public void setOutputFileName(String outputFile) throws Exception;
	
    /**
     *	Returns fully qualified path and filename of the job script.
     *
     *	@return job script
     */
    public String getJobScript();
    
     /**
     *	Sets the  fully qualified path and filename of the job script.
     */
    public void setJobScript(String jobScriptName) throws Exception;
   
    /**
     *	Returns fully qualified path and filename of the kill script.
     *
     *	@return kill script
     */
    public String getKillScript();
    
     /**
     *	Sets the fully qualified path and filename of the kill script.
     */
    public void setKillScript(String killScriptName) throws Exception;
     
    /**
     *	Returns space separated list of job script parameters.
     *
     *	@return job script parameters
     */
    public String getJobScriptParameters(); 
    
    /**
     *	Sets the next  job script parameter. 
     */
    public void setJobScriptParameters(String jobParamName) throws Exception;

    /**
     *	Returns service-side name of the finish file.
     *
     *	@return finish file name
     */ 
    public String getFinishFileName();
    
    /**
     *	Sets the service-side filename of the finish file. 
     */
    public void setFinishFileName(String finishFileName) throws Exception;
    
      /**
     *	Returns fully qualified path and filename of the status script.
     *
     *	@return status script
     */
    java.lang.String getStatusScript();
   
   /**
     *	Sets the fully qualified path and filename of the status script.
     */
    public void setStatusScript(String statusScript)throws Exception; 
    
    /**
     *	Returns service-side filename of the status file.
     *
     *	@return filename of the status file
     */
    java.lang.String getStatusFile();

    /**
     *	Sets the service-side filename of the status file. 
     */
    public void setStatusFile(String statusFileName)throws Exception;

    //-----------------
    // Recovery Section
    //-----------------
     
    
    /**
     *	Returns fully qualified path and filename of the restart script.
     *
     *	@return restart script
     */
    public String getRestartScript();
    
    /**
     *	Sets the fully qualified path and filename of the restart script.
     */
    public void setRestartScript(String restartScriptName) throws Exception;
    
    /**
     *	Returns service-side filename of the checkpoint input file.
     *
     *	@return filename of the input file
     */ 
    public String getCheckpointInputFileName();
    
    /**
     *	Sets the service-side filename of the checkpoint input file. 
     */ 
    public void setCheckpointInputFileName(String inputFile) throws Exception;
    
    /**
     *	Returns service-side filename of the checkpoint output file.
     *
     *	@return filename of the input file
     */
    public String getCheckpointOutputFileName();
    
    /**
     *	Returns array from all filenames of the checkpoint output file. 
     */
    public String[] getCheckpointOutputFileNames();
    /**
     *	Sets the service-side filename of the checkpoint output file. 
     */
    public void setCheckpointOutputFileName(String inputFile) throws Exception;
    
    // -----------------------------
    // Performance Parameter Section
    // -----------------------------
    
    /**
     *	Returns  array of performance parameters.
     */
    public String[] getPerformanceParameterNames();
  
    /**
     *	Sets the performance parameters.
     */
    public void setPerformanceParameterNames(String[] names)throws Exception;
    
    /**
     *	Return the number of nodes. 
     */
    public int[] getNumberOfNodes();
    
    /**
     *	Sets the number of nodes. 
     */
    public void setNumberOfNodes(int[] nodes) throws Exception;
    
    // business model 

     /**
     *	Returns fully qualified class name of the business model. 
     *  @see  at.ac.univie.iss.bm.BusinessModel
     */	
    public String getBusinessModelClass();
    
    /**
     *	Sets fully qualified class name of the business model. 
     *  @see  at.ac.univie.iss.bm.BusinessModel
     */	
    public void setBusinessModelClass(String businessModelClass)throws Exception;
	
    /**
     *	Returns the business model configuration. 
     */
    public String getBusinessModelConfiguration(); 
    
     /**
     *	Sets the business model configuration. 
     */
    public void setBusinessModelConfiguration(String value)throws Exception;
  
   /**
     *	Returns fully qualified class name of the performance model. 
     *  @see  at.ac.univie.iss.apm.PerformanceModel
     */
    public String getPerformanceModelClass();
    
     /**
     *	Sets fully qualified class name of the performance model.
     *  @see  at.ac.univie.iss.apm.PerformanceModel
     */
    public void setPerformanceModelClass(String perfModelClass)throws Exception;
	
    /**
     *	Returns the performance model configuration. 
     */
    public String getPerformanceModelConfiguration();  
    
     /**
     *	Sets the performance model configuration. 
     */
    public void setPerformanceModelConfiguration(String value)throws Exception;

    /**
     *	Returns fully qualified class name of the compute resource manager. 
     *  @see  at.ac.univie.iss.crm.ComputeResourceManager
     */	
    public String getComputeResourceManagerClass();
    
     /**
     *	Sets fully qualified class name of the compute resource manager. 
     *  @see  at.ac.univie.iss.crm.ComputeResourceManager
     */	
    public void setComputeResourceManagerClass(String crmClass)throws Exception;
      
}
