/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/05/19 14:05:53 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////
package at.ac.univie.iss.descriptors.qos;

/**
*	A Performance Descriptor is an XML document representing the output of a
*	machine specific application performance model. 
*	A <code>PerformanceDescriptor</code> represents an XML Performance 
*	Descriptor in Java and provides access methods for all necessary 
*	information stored in a Performance Descriptor. 
*
*	@author Gerhard Engelbrecht
*	@author Nikolay Terziev
*/
public interface PerformanceDescriptor {
    
    /**
    *	Sets the runtime of this job.
    */
    public void setRuntime(double runtime);

    /**
    *	Returns the runtime of this job.
    */
    public double getRuntime();
    
    /**
    *	Sets the disc requirements of this job.
    */
    public void setDiscRequirement(int disc);

    /**
    *	Returns the disc requirements of this job.
    */
    public int getDiscRequirement(); 
    
    /**
    *	Sets the memory requirements of this job.
    */
    public void setMemoryRequirement(int memory);

    /**
    *	Returns the memory requirements of this job.
    */
    public int getMemoryRequirement();   
}
