/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/07/30 14:01:34 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.descriptors.qos;


import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Logger;
import java.util.logging.Level;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

import at.ac.univie.iss.descriptors.qos.jaxb.perfdesc.*; 


/**
*	A Performance Descriptor is an XML document representing the output of a
*	machine specific application performance model. 
*	A <code>PerformanceDescriptorImpl</code> implements the interface <code>
*	PerformanceDescriptor</code>which represents an XML Performance Descriptor
*	in Java. Internally this class uses JAXB to access the content of the XML
*	Performance Descriptor. 
*
*	@author Gerhard Engelbrecht
*	@author Nikolay Terziev
*/
public class PerformanceDescriptorImpl  implements PerformanceDescriptor {
    
    private static Logger logger = Logger.getLogger("at.ac.univie.iss.descriptors.qos");

    private Unmarshaller unmarshaller = null;
    private Marshaller   marshaller = null;
    private ObjectFactory objFactory = null;
    private JAXBContext jc;
    
    private at.ac.univie.iss.descriptors.qos.jaxb.perfdesc.PerformanceDescriptor performanceDescriptor = null;
    
    /**
    *	Creates an empty Performance Descriptor.
    */
    public PerformanceDescriptorImpl() {
    
        try {
         
            jc = JAXBContext.newInstance("at.ac.univie.iss.descriptors.qos.jaxb.perfdesc");
                    
            unmarshaller = jc.createUnmarshaller();
            unmarshaller.setValidating(true);

            marshaller = jc.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

            objFactory = new ObjectFactory(); 
            
            performanceDescriptor = objFactory.createPerformanceDescriptor();
            
            performanceDescriptor.setRuntime(0);
              
        } catch (JAXBException je) {

        	logger.log(Level.SEVERE, "An error occured while creating a new Performance Descriptor (see details below)!", je);
        }  
    }
 
    /**
    *	Creates Performance Descriptor based on the given XML String.
    */
    public PerformanceDescriptorImpl(String perfDesc) {
    
        try {
         
            jc = JAXBContext.newInstance("at.ac.univie.iss.descriptors.qos.jaxb.perfdesc");
                    
            unmarshaller = jc.createUnmarshaller();
            unmarshaller.setValidating(true);

            marshaller = jc.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

            objFactory = new ObjectFactory(); 
            
            performanceDescriptor = (at.ac.univie.iss.descriptors.qos.jaxb.perfdesc.PerformanceDescriptor) unmarshaller.unmarshal(
                    new StreamSource(new StringReader(perfDesc)));
     
        } catch (UnmarshalException ue) {  
            
        	logger.log(Level.SEVERE, "An error occured while creating a new Performance Descriptor based on a given String (see details below)!", ue);

        } catch (JAXBException je) {

        	logger.log(Level.SEVERE, "An error occured while creating a new Performance Descriptor based on a given String (see details below)!", je);
            
        } catch (Exception e) {

        	logger.log(Level.SEVERE, "An error occured while creating a new Performance Descriptor based on a given String (see details below)!", e);
        }  
    }
    
    public void setRuntime(double runtime){
    
     performanceDescriptor.setRuntime(runtime);
    }
    
    public double getRuntime(){
      
      return performanceDescriptor.getRuntime();
    }
    
    public void setDiscRequirement(int disc){
        
      performanceDescriptor.setDiscRequirement(disc);
    }
    
    public int getDiscRequirement(){
    
     return  performanceDescriptor.getDiscRequirement();
    }
    
    public void setMemoryRequirement(int memory){
    
        performanceDescriptor.setMemoryRequirement(memory);
    }
    
    public int getMemoryRequirement(){
        
      return  performanceDescriptor.getMemoryRequirement();
    }
    
  	/** 
  	* 	Returns an XML document of this Performance Descriptor as String.
  	*/
    public String toString() {
            
        StringWriter slaWriter = new StringWriter(); 
            
        try {
             
            marshaller.marshal(performanceDescriptor, slaWriter);
             
            return slaWriter.toString();
           
        } catch (javax.xml.bind.MarshalException me) { 

        	logger.log(Level.SEVERE, "An error occured while converting the Performance Descriptor to a String (see details below)!", me);

        } catch (JAXBException je) {

        	logger.log(Level.SEVERE, "An error occured while converting the Performance Descriptor to a String (see details below)!", je);
        }
        return null;  
    }
}
