/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:14:40 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.descriptors.qos;

/**
*	A QoS Descriptor is an XML document representing a (potential) agreement
*	about one job execution between a service consumer (client) and a service
*	provider following the Web Service Level Agreement (WSLA) specification. 
*	A <code>QoSDescriptor</code> represents an XML QoS Descriptor in Java and
*	provides access methods for all necessary information stored in a QoS
*	Descriptor. 
*
*	@author Gerhard Engelbrecht
*	@author Nikolay Terziev
*/
public interface QoSDescriptor {
    
    /**
    *	Sets the name attribute of the SLA root element.
    */
    public void setSLAName(String slaName);

    /**
    *	Returns the name attribute of the SLA root element.
    */
    public String getSLAName();

    /**
    *	Sets the name of the service provider involved in this QoS Descriptor.
    */
    public void setProviderName(String providerName) throws Exception;

	/**
	*	Returns the name of the service provider involved in this QoS 
	*	Descriptor.
	*/
    public String getProviderName();
    
    /**
    *	Sets the name of the service consumer involved in this QoS Descriptor.
    */
    public void setConsumerName(String consumerName) throws Exception;

	/**
	*	Returns the name of the service consumer involved in this QoS 
	*	Descriptor.
	*/
    public String getConsumerName();
    
    /**	
    *	Sets the objective price for this service in this QoS Descriptor.
    */
    public void setObjectivePrice(double price)throws Exception;

	/**
	*	Returns the objective price of this service specified in this QoS 
	*	Descriptor.
	*/
    public double getObjectivePrice();
    
	/**
	*	Sets the earliest possible begin time for this job in this QoS 
	*	Descriptor.
	*/
    public void setObjectiveBeginTime(java.util.Calendar date) throws Exception;

	/**
	*	Returns the earliest possible begin time for this job in this QoS 
	*	Descriptor.
	*/
    public java.util.Calendar getObjectiveBeginTime();
    
	/**
	*	Sets the latest possible end time for this job in this QoS 
	*	Descriptor.
	*/
    public void setObjectiveEndTime(java.util.Calendar date) throws Exception;

	/**
	*	Returns the latest possible end time for this job in this QoS 
	*	Descriptor.
	*/
    public java.util.Calendar getObjectiveEndTime();
    
	/**
	*	Tests if the given QoS Descriptor is equal to this QoS Descriptor
	*/
    public boolean equals(Object qosDesc);
}
