/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/19 14:05:53 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.descriptors.qos;

/**
*	A Request Descriptor is an XML document containing application specific
*	meta information about a service request. This meta information may 
*	inlcude mesh size, image resolution, etc.
*	A <code>RequestDescriptor</code> represents an XML Request Descriptor in
*	Java and provides access methods for all necessary information stored in a 
*	Request Descriptor. 
*
*	@author Gerhard Engelbrecht
*	@author Nikolay Terziev
*/
public interface RequestDescriptor {
    
    /**
    *	Sets the service category of this Request Descriptor.
    */
    public void setServiceCategory(String serviceCategory);

    /**
    *	Returns the service category of this Request Descriptor.
    */
    public String getServiceCategory();
    
	/**
	*	Sets an performance parameter as name-value pair for this Request 
	*	Descriptor.
	*/
    public void setPerformanceParameter(String name,String value);
	
	/**
	*	Returns the value of the performance parameter specified by the
	*	given name of this Request Descriptor.
	*/
    public String getPerformanceParameter(String name); 
    
	/**
	*	Returns an XML document of this Request Descriptor as String.
	*/
    public String toString();
}
