/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/02/10
//	Created for Project:	GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/25/03 15:20:12 $
//					$Revision: 1.5 $
//
/////////////////////////////////////////////////////////////////////////
package at.ac.univie.iss.discovery.examples;


import java.util.Iterator;
import java.util.List;
import java.util.Set;

import eu.gemss.GEMSS;
import eu.gemss.components.ComponentManager;  
import eu.gemss.components.discovery.*;
import eu.gemss.components.discovery.Discovery;


public class DiscoveryExample {
        
    final public static void main(String[] args) {
	
        // create new attribute array (with length 1)

        Attribute[] attributes = new Attribute[1];
		
        System.out.print("Initializing component manager ... ");
        
        ComponentManager cm = GEMSS.getInstance();
		
        System.out.println("done.");

        System.out.print("Retrieving set of all available components ... ");

        Set	sop = cm.getComponents(); // set of providers
		
        System.out.println("done.");

        System.out.print("Creating iterator of providers ... ");

        Iterator iop = sop.iterator(); // iterator of providers
		
        System.out.println("done.");

        System.out.println("Provider list:");
        
        while (iop.hasNext()) {
		
            Object next = iop.next();
		
            System.out.println(" - " + next);
        }
		
        System.out.println("Provider list finished.");
        System.out.print("Creating discovery component ... ");

        Discovery discovery = (Discovery) cm.getInstance(
                "eu.gemss.components.discovery.Discovery");
		
        System.out.println("done.");

        System.out.print("Creating set of attributes ... ");
        
        attributes[0] = new Attribute();
        attributes[0].setValue("SPECT");
        attributes[0].setName("ServiceCategory");

        System.out.println("done.");

        System.out.print("Starting discovery ... ");

        try {
            // retrieve list of services from discovery component

            List services = discovery.discoverServices(attributes); 
        
            System.out.println("done.");

            System.out.print("Creating iterator of available services ... ");

            Iterator iter = services.iterator();
        
            System.out.println("done.");

            System.out.println("Available services:");

            // iterate through list of services
        
            while (iter.hasNext()) {
                
                ServiceDescription service = (ServiceDescription) iter.next();
                
                // get list of attributes from each service
                
                Attribute[] attrList = service.getAttributes();

                // print wsdl endpoint and all attributes
                System.out.println(
                        "--> Service WSDL endpoint " + service.getWsdlEndpoint());

                if (attrList != null) {     
                                     
                    for (int i = 0; i < attrList.length; i++) {
                        System.out.println(
                                "    - Attribute name : "
                                        + attrList[i].getName() + ", value : "
                                        + attrList[i].getValue());
                    }
                }  
               
            }
        } catch (eu.gemss.GridException ge) {
            
            System.err.println(ge.getUserMessage());  
        }
        System.out.println("Discovery example finished!");
    }
	
}
	
