/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/02/10
//	Created for Project:	GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/25/03 15:20:12 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////
package at.ac.univie.iss.discovery.provider;
 
import eu.gemss.components.ServiceRequest;
import eu.gemss.components.providers.Provider;
import eu.gemss.components.discovery.Discovery;

import at.ac.univie.iss.discovery.impl.DiscoveryImpl;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.Set;

/** Provider class for the Discovery comonent. */
public class DiscoveryProvider implements Provider {
    
    private static Logger logger = Logger.getLogger(  DiscoveryProvider.class.getName());
    private static final String componentName = "eu.gemss.components.discovery.Discovery";
    private static final String description = "Discovery Component by ISS";
    private static final String providerName = "ISS";
    private static final String version = "0.1";
    private static final boolean isLocal = true;
	 
    /** Creates a new Discovery provider. */
    public DiscoveryProvider() {// System.out.println("DiscoveryProvider.init()");
    }
	
    /** Creates an instance of the component supported by this provider. */
    public Object createComponent() {
	
        // System.out.println("DiscoveryProvider.createComponent()");
	
        Discovery discovery = new DiscoveryImpl();
        try{

            discovery.init();
        
        } catch(eu.gemss.GridException de){
         
            logger.log(java.util.logging.Level.SEVERE, de.toString(), de);       
        }
        return discovery;
    }

    /** Creates a component instance using the specified service request. */
    public Object createComponent(ServiceRequest sr) {
        // System.out.println("DiscoveryProvider.createComponent(ServiceRequest sr)");
        return this.createComponent();
    }

    /** Returns a string identifying the component supported by this provider. */
    public String getComponentName() {
		
        // System.out.println("DiscoveryProvider.getComponentName()");

        return componentName;
    }
	
    /** Returns a human readable description of the specified component. */
    public String getDescription() {
		
        // System.out.println("DiscoveryProvider.getDescription()");

        return description;
    }

    /** Returns a non-null string identifying the name of the owner of this provider and the associated components it implements. */
    public String getProviderName() {
		
        // System.out.println("DiscoveryProvider.getProviderName()");

        return providerName;
    }

    /** Returns a string identifying the version of the component supported by this provider. */
    public String getVersion() {

        // System.out.println("DiscoveryProvider.getVersion()");

        return version;
    }

    /** Ask whether the component will run locally or remotely. */
    public boolean isLocal() {

        // System.out.println("DiscoveryProvider.isLocal()");

        return isLocal;
    }

    /** Determine whether or not this provider supports the specified component. */
    public boolean supports(String component) {

        // System.out.println("DiscoveryProvider.supports(" + component + ")");

        return false;
    }
}

