/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Nikolay Terziev
//	Created Date :		2004/02/10
//	Created for Project:	GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: niki $
//					$Date: 2004/25/03 15:20:12 $
//					$Revision: 1.2 $
//
/////////////////////////////////////////////////////////////////////////
package at.ac.univie.iss.discovery.util;


import java.io.File;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


/**
 *  In the registry properties file are written all the registry's URLs. 
 **/ 
public class EndpointReader {

    String registryPropFile;

    public EndpointReader(String registryPropFile) {
        
        this.registryPropFile = registryPropFile;        
    }
    
    /**
     *  Reads the file and returns a <code>List</code> from URLs
     * 
     * @return List
     * 
     * @throws java.io.IOException
     **/
    public List getURIs() throws IOException {
        
        List registryInfo = new ArrayList(); 
        String uri;
      
        BufferedReader br = new BufferedReader(
                new InputStreamReader(new FileInputStream(registryPropFile)));
        String line = "";

        while (((line = br.readLine()) != null) && (line.trim().length() > 0)) {
    
            if (!line.startsWith("#")) {

                registryInfo.add(line);  
            }
        }
           
        br.close();
          
        return registryInfo;
    }
}
