/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Rainer Schmidt
//	Created Date :		2004/08/15
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/08/19 08:15:06 $
//					$Revision: 1.6 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.proxies.qos.examples;

/**
 * Example 1/3
 * This example shows basic job handling in the GEMSS environment
 * using GEMSSProxy.
 * ------------------
 * JobHandling    [+]
 * Discovery      [-] 
 * QoSNegotiation [-]
 */

import java.util.logging.Level;
import java.util.logging.Logger;
import java.io.*;
import java.util.*;

import eu.gemss.GEMSS;
import eu.gemss.GridException;
import eu.gemss.components.ComponentManager;  
import eu.gemss.components.transport.GEMSSTransportAndMessaging; 

import eu.gemss.components.ServiceRequest;
import eu.gemss.components.proxies.GEMSSProxyRequest;
import eu.gemss.components.proxies.GEMSSProxy;

import at.ac.univie.iss.proxies.qos.util.PropertiesHandler;

public class JobHandlingExample {
    
    private static Logger logger = Logger.getLogger(JobHandlingExample.class.getName());

	//file that will be uploaded to the services
    private String uploadFile = "input.zip";

    //URI the the service WSDL file
    private static String wsdlURIofService = "https://unicore.ccrl-nece.de/gemss/services-p3/HelloWorldUnix/appex?wsdl";


    public ComponentManager cm;
    public PropertiesHandler propertiesHandler = null;
    //endpoint configuration file    
    public String endPointBase = "config" + File.separator + "EndPoint.config";
    //service endpoint configuration file, will be generated
    public String endPointTemp = "config" + File.separator + "EndPoint_temp.config";
    
    public StringBuffer status = new StringBuffer();
 

    public JobHandlingExample() {
        cm = GEMSS.getInstance();
        propertiesHandler = new PropertiesHandler();
    }   
    
    public static void main(String[] args) {

        JobHandlingExample jobHandlingExample = new JobHandlingExample();

        logger.log(Level.INFO, "Running job handling.");
        jobHandlingExample.runJobHandling(System.currentTimeMillis()+"-myName", wsdlURIofService);
    }     
   
    final public void runJobHandling(String convId, String wsdlURI) {
        try {
        	//load service properties from file
        	propertiesHandler.loadProperties(endPointBase);
        	//add wsdl URI
			
			propertiesHandler.setProperty("WSDLURI", wsdlURI);
			// save to temporary file
            propertiesHandler.saveProperties(endPointTemp);
        	
            GEMSSProxyRequest req = new GEMSSProxyRequest(endPointTemp, "eu.gemss.components.proxies.GEMSSProxy", null, null);
            GEMSSProxy proxy = (eu.gemss.components.proxies.GEMSSProxy) cm.getInstance(req);
            
            //As negotiation is not used and GEMSSProxy does not allow the user to request an converstation id,
            //the id is generated at the client side.
            proxy.setJobConversationID(convId);

            status.append("Set Id");
            
            logger.log(Level.INFO, "Uploading data.");
            proxy.uploadData(uploadFile);

            status.append(" -> Uploaded");

            logger.log(Level.INFO, "Starting job.");
            proxy.start();

            status.append(" -> Started");

            logger.log(Level.INFO, "Waiting job to finish");
               
            String gstatus = proxy.getStatus();
            status.append(" -> status query ");
            while (!(gstatus = proxy.getStatus()).equals("FINISHED")) {
                Thread.sleep(5000);
                status.append(".");
                logger.log(Level.INFO, "Status Info: \n" + gstatus + "\n");
                
            }
            logger.log(Level.INFO, "");
            logger.log(Level.INFO, proxy.getStatus());
            status.append(" -> Finished");
            
            logger.log(Level.INFO, "Downloading data.");
            
            //write output to following file
            proxy.downloadData("", "outputData");

            status.append("-> Downloaded");

            logger.log(Level.INFO, "AcknowledgeResults.");
            proxy.acknowledgeResults();

            status.append("-> Acknowledged!!!");

        } catch (eu.gemss.GridException ge) {
            logger.log(Level.SEVERE, "An error occured!", ge);
        } catch (Exception e) {
            logger.log(Level.SEVERE, "An error occured!", e);
        }
    
    }    
}

