/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/08/09 09:41:38 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.proxies.qos.provider;


import eu.gemss.components.ServiceRequest;
import eu.gemss.components.providers.Provider;
import eu.gemss.components.proxies.qos.QoSProxy;
import eu.gemss.components.proxies.qos.GenericProxyRequest;
import eu.gemss.components.proxies.GEMSSProxyRequest;

import at.ac.univie.iss.proxies.qos.impl.QoSProxyImpl;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.Set;
import java.io.IOException;


/** Provider class for the Discovery comonent. */
public class QoSProxyProvider implements Provider {
    
    private static Logger logger = Logger.getLogger(QoSProxyProvider.class.getName());
    private static final String componentName = "eu.gemss.components.proxies.qos.QoSProxy";
    private static final String description = "BasicQoS Component by ISS";
    private static final String providerName = "ISS";
    private static final String version = "1.0";
    private static final boolean isLocal = true;
	 
    /** Creates a new Discovery provider. */
    public QoSProxyProvider() {}
	
    /** Creates an instance of the component supported by this provider. */
    public Object createComponent() throws IOException {
        return new QoSProxyImpl(null);
    }

    /** Creates a component instance using the specified service request. */     
    public Object createComponent(ServiceRequest serviceRequest) throws IOException {
        QoSProxy qosProxy = null;

        if (serviceRequest instanceof GenericProxyRequest) {
            qosProxy = new QoSProxyImpl(((GenericProxyRequest) serviceRequest).getConfigFile());
        } else if (serviceRequest instanceof GEMSSProxyRequest) {
            qosProxy = new QoSProxyImpl(((GEMSSProxyRequest) serviceRequest).getConfigFile());
        } else {
            logger.info("No service endpoint property file found in serviceRequest using default values");
            qosProxy = new QoSProxyImpl(null);      	
        }
        return qosProxy;
    }

    /** Returns a string identifying the component supported by this provider. */
    public String getComponentName() {
		
        return componentName;
    }
	
    /** Returns a human readable description of the specified component. */
    public String getDescription() {
		 
        return description;
    }

    /** Returns a non-null string identifying the name of the owner of this provider and the associated components it implements. */
    public String getProviderName() {
		 
        return providerName;
    }

    /** Returns a string identifying the version of the component supported by this provider. */
    public String getVersion() {

        return version;
    }

    /** Ask whether the component will run locally or remotely. */
    public boolean isLocal() {
 
        return isLocal;
    }

    /** Determine whether or not this provider supports the specified component. */
    public boolean supports(String component) {

        return false;
    }
}

