/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/08/09 09:41:34 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.proxies.qos.util;


import java.util.logging.*; 
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream; 
import java.util.Properties; 


public class PropertiesHandler {

    private static Logger logger = Logger.getLogger(PropertiesHandler.class.getName());
  
    Properties properties = new Properties();

    public void loadProperties(String propertyFilePath) throws Exception { 
    
        if (propertyFilePath == null) {
            propertyFilePath = "null";
        }
        File tempPropsFile = new File(propertyFilePath);

        if (!tempPropsFile.exists()) {
            logger.log(Level.WARNING,
                    "Propertyfile " + propertyFilePath + " does not exist");
            // throw new Exception("The " + propertyFilePath + " does not exist !!!");
        } else {
            if (!tempPropsFile.isFile()) {
                logger.log(Level.WARNING,
                        "Propertyfile " + propertyFilePath + " does not exist");  
                // throw new Exception("The " + propertyFilePath + " is not a file !!!");
            } else { 
                FileInputStream in = new FileInputStream(tempPropsFile);

                properties.load(in);
                in.close(); 
            }
        } 
    }

    public void saveProperties(String propertyFilePath) throws Exception {  
      
        File tempPropsFile = new File(propertyFilePath);
        FileOutputStream out = new FileOutputStream(tempPropsFile);

        properties.store(out,
                "EndPoint.config - generated by the BasicQoS component.");
        out.close(); 
    }
 
    public void setProperty(String key, String value) {
        properties.setProperty(key.trim(), value.trim()); 
    }  
    
    public String getProperty(String key) {
        return properties.getProperty(key.trim());
    }
}
