/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Aleksandar Dimitrov
//	Created Date :		2004/02/24
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: dimitrov $
//					$Date: 2004/07/21 12:10:44 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.registry;


/**
 * This class is used to describe an Application
 * Service in form of an arbitrary name/value pair. 
 */
public class Attribute implements java.io.Serializable {

    private java.lang.String name;
    private java.lang.String value;

    /**
     * Constructs an empty name/value pair.
     */
    public Attribute() {
		
        name = null;
        value = null;
    }	
	
    /**
     * Constructs an arbitrary name/value pair.
     */
    public Attribute(java.lang.String name, java.lang.String value) {
	
        this.name = name;
        this.value = value;
    }
	
    /**
     * Returns the name of this attribute.
     */
    public java.lang.String getName() {
        return name;
    }
	
    /**
     * Sets the name of this attribute.
     */	
    public void setName(String name) {	
        this.name = name;
    }

    /**
     * Returns the value of this attribute.
     */	
    public java.lang.String getValue() {	
        return value;
    }

    /**
     * Sets the value of this attribute.
     */	
    public void setValue(String value) {	
        this.value = value;
    }
}
