/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Aleksandar Dimitrov
//	Created Date :		2004/02/24
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: dimitrov $
//					$Date: 2004/05/28 10:25:43 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////


package at.ac.univie.iss.registry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.ClassCastException;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.Vector;

/**
 * The class DataStore represents the store of registry.
 * In general as store s using a file, in which will be
 * saved the services descriptions as Vector object.
 */
public class DataStore {

    private String dataFile = "../temp/data.dat";
    private Vector storeOfData;
    private static Logger logger = null;

    /**
     * Creates a new Vector object, that is used for temporary 
     * store of registry data.
     */	
    public DataStore() {
		
        storeOfData = new Vector();
        logger = Logger.getLogger("logging.registry");	
    }

    /**
     * Creates a new Vector object, that is used for temporary 
     * store of registry data. 
     * 
     * @param	dataFile A pathname string to the data file
     */		
    public DataStore(String dataFile) {
		
        this.dataFile = dataFile;
        storeOfData = new Vector();
        logger = Logger.getLogger("logging.registry");	
    }

    /**
     * Loades the whole information from a database file to a Vector object,
     * which is a return value of this method.
     * By default the dataFile is "../temp/data.dat". It can be changed
     * via the constructor of this class DataStore(String dataFile).
     *
     * @throws  RemoteException if an error occured
     *			during the reading of the database file:
     *          - the database file is not found - FileNotFoundException
     *          - the database file has an incorrect format - StreamCorruptedException
     *          - the database file has an incorrect format - ClassCastException
     */		
    public synchronized Vector load() throws RemoteException {
				
        try {
		    
            // at first a database file is loaded and then read.
            // The read object has to be a Vector and is 
            FileInputStream fis = new FileInputStream(this.dataFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);

            storeOfData = (Vector) ois.readObject();
            ois.close();									
        } catch (FileNotFoundException e) {
			
            // if a database file does not exist then 
            // it will be at first created and then loaded.
            store(storeOfData);
			
            logger.log(Level.INFO, 
                    "DB-WARNING: db file has not been found and it will be created!\n");
		  	
            load();		  	
        } catch (StreamCorruptedException e) {			
            logger.log(Level.SEVERE, 
                    "DB-Exception: db file has an invalid format: StreamCorruptedException");			
            throw new RemoteException("DB-Exception");
        } catch (ClassCastException e) {			
            logger.log(Level.SEVERE, 
                    "DB-Exception: db file has an invalid format: ClassCastException");			
            throw new RemoteException("DB-Exception");
        } catch (IOException e) {
            logger.log(Level.SEVERE, "DB-Exception - DataStore.load()", e);
            throw new RemoteException("DB-Exception");
        } catch (Exception e) {
            logger.log(Level.SEVERE, "DB-Exception - DataStore.load()", e);
            throw new RemoteException("DB-Exception");
        }		
		
        return storeOfData;		
    }

    /**
     * Stores the description of the services (ServiceDescription 
     * object - uri, attributes) in a file. 
     * This description is in a form of Vector object.
     *
     * @throws  RemoteException if an error occured
     *			during the store of the service description
     *
     * @param	newData Vector object, which contain the whole
     information, that will be stored in a file
     */	
    public synchronized void store(Vector newData) throws RemoteException {
		
        try {
            // the specified database file will be created and 
            // the dates in form of Vector will be written to it.		
            FileOutputStream fos = new FileOutputStream(dataFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            
            oos.writeObject(newData);
            oos.close();
        } catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "DB-Exception - DataStore.store()", e);
            throw new RemoteException("DB-Exception");
        } catch (IOException e) {
            logger.log(Level.SEVERE, "DB-Exception - DataStore.store()", e);
            throw new RemoteException("DB-Exception");
        } catch (Exception e) {
            logger.log(Level.SEVERE, "DB-Exception - DataStore.store()", e);
            throw new RemoteException("DB-Exception");
        }						
    }
}
