/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Aleksandar Dimitrov
//	Created Date :		2004/02/24
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: dimitrov $
//					$Date: 2004/07/21 12:10:44 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.registry;

import java.rmi.RemoteException;
import java.util.Vector;

import at.ac.univie.iss.registry.Attribute;
import at.ac.univie.iss.registry.ServiceDescription;


/**
 * The Registry Interface is the main interface
 * of the Registry Service. It contains three
 * methods: publishService, removeService and query.  
 */
public interface Registry {

    /**
     * Queries the Registry Service and returns a Vector
     * of ServiceDescription that meet certain criteria(attribute).
     *
     * @throws  RemoteException if an error occured
     *			during the query of the service
     *
     * @param	attribute array of service descriptions
     *          in a form of one or more Name/Value pairs
     *
     * @see		at.ac.univie.iss.registry.Attribute	 
     */
    public Vector query(Attribute[] attribute) throws RemoteException;

    /**
     * Publishes an Application Services in the Registry
     * Service based on the given ServiceDescription.
     *
     * @throws  RemoteException if an error occured
     *			during the publishing of the service
     *
     * @param	service object that is used for 
     *          description of existing service description
     *
     * @see		at.ac.univie.iss.registry.ServiceDescription	
     */
    public void publishService(ServiceDescription service) throws RemoteException;

    /**
     * Removes an Application Service from the Registry Service.
     *
     * @throws  RemoteException if an error occured
     *          during the removing of the service description
     *
     * @param   serviceURI URI of the service that will be 
     *          remove(unregister) from registry
     */
    public void removeService(String serviceURI) throws RemoteException;	
}
