/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Aleksandar Dimitrov
//	Created Date :		2004/03/25
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: dimitrov $
//					$Date: 2004/07/21 12:10:44 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.registry;


/**
 * This class comprises basic information about an
 * Application Service including a mandatory WSDL endpoint URI
 * and an optional set of attributes. Basic access methods
 * (get/set) are provided in order to manipulate ServiceDescription
 * objects. All attributes are stored in an array of Attribute objects.
 */ 
public class ServiceDescription implements java.io.Serializable {
	
    private Attribute[] attributes;
    private String wsdlEndpoint;

    /**
     * Constructs an empty service object.
     */
    public ServiceDescription() {
        
        this.wsdlEndpoint = null;
        this.attributes = null;
    }

    /**
     * Constructs a service object with appropriate
     * endpoint URI and attributes.
     */    
    public ServiceDescription(Attribute[] attributes, String wsdlEndpoint) {

        this.attributes = attributes;
        this.wsdlEndpoint = wsdlEndpoint;
    }

    /**
     * Returns an array of Attribute (arbitrary name/value pairs)
     * for this ServiceDescription.
     */	
    public Attribute[] getAttributes() {
		
        return attributes;
    }	
    
    /**
     * Sets all attributes (arbitrary name/value pairs) for
     * this ServiceDescription with the given array Attribute.
     */    
    public void setAttributes(Attribute[] attributes) {
        
        this.attributes = attributes;
    }
    
    /**
     * Returns the WSDL endpoint URI of this ServiceDescription.
     */
    public String getWsdlEndpoint() {
    
        return wsdlEndpoint;
    }
    
    /**
     * Sets the WSDL endpoint URI of the ServiceDescription.
     */        
    public void setWsdlEndpoint(String wsdlEndpoint) {
    
        this.wsdlEndpoint = wsdlEndpoint;
    }    
}
