/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/19 13:58:33 $
//					$Revision: 1.3 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service;

import java.rmi.RemoteException;

/**
*	The <code>QoS</code> interface provides a method for enabling clients to
*	negotiate certain QoS properties with a service provider before actually
*	consuming a service. Furthermore, the <code>QoS</code> interface provides
*	methods for confirmation and cancellation of QoS Descriptors. 
*	<p>
*	Note: The QoS Descriptor and the Request Descriptor passed as arguments
*	are represented at this level via Strings containing an XML document.
*
*	@author		Gerhard Engelbrecht
*	@see		at.ac.univie.iss.descriptors.qos.QoSDescriptor
*	@see		at.ac.univie.iss.descriptors.qos.RequestDescriptor
*/
public interface QoS {

	/**
	*	Returns an offer from the service based on the given Request 
	*	Descriptor and QoS Descriptor in form on a new QoS Descriptor. 
	*	<p>
	*	Internally this method firstly validates the given parameters against
	*	the appropriate Schemata. Further this method creates estimations
	*	based on the specific application performance models and attempts to
	*	make temporary reservations on available resources.
	*
	*	@param		qoSDescriptor QoS Descriptor containing certain QoS 
	*				constraints	(e.g. earliest start time, latest finish time,
	*				cost).
	*	@param		requestDescriptor Request Descriptor containing meta 
	*				information about the user request (e.g. mesh size, image
	*				resolution). 
	*
	*	@return		A new QoS Descriptor representing a service offer.
	*
	*	@throws		java.rmi.RemoteException standard java remote exception
	*				with detailed information about the exception (e.g. input
	*				descriptors can not be validated against Schema, etc.). 
	*/
    public String requestQoSDescriptor(String qoSDescriptor, String requestDescriptor) throws RemoteException;
    
    
    /**
    *	Confirms the given QoS Descriptor and returns a doubly confirmed (by 
    *	client and service) QoS Descriptor.
    *	<p>
    *	Internally this method confirms the temporary resource reservation from
    *	the requestQoSDescriptor method and confirms the client-confirmed QoS
    *	Descriptor for return.
    *
    *	@param		qoSDescriptor QoS Descriptor confirmed by the client.
    *
    *	@return		A doubly confirmed QoS Descriptor.
    *
    *	@throws		java.rmi.RemoteException standard java remote exception 
    *				with detailed information about the exception(e.g. input
    *				descriptors can not be validated against Schema, etc.).
	*
	*/
    public String confirmQoSDescriptor(String qoSDescriptor) throws RemoteException;


	/**
	*	Cancels the given QoS Descriptor. Internally the temporary resource
	*	reservation will be canceled.
	*	<p>
	*	@param		qoSDescriptor QoS Descriptor to cancel. 
	*
	*	@throws		java.rmi.RemoteException standard java remote exception
	*				with detailed information about the exception(e.g. input
	*				descriptors can not be validated against Schema, etc.).
	*/
    public void cancelQoSDescriptor(String qoSDescriptor) throws RemoteException;

}
