/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/28 16:33:55 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service;

import java.rmi.RemoteException;

import javax.activation.DataHandler;


/**
*	The <code>Recovery</code> interface provides a methods for checkpointing
*	and restarting of native applications (if the native application provides
*	support for Recovery).
*	<p>
*	Note: The functionality is not yet fully implemented.
*
*	@author		Gerhard Engelbrecht
*/
public interface Recovery {

	/**
	*	Restarts the native application.
	*	<p>
	*	@param		cid client identification
	*
	*	@throws		java.rmi.RemoteException standard java remote exception
	*				with detailed information about the exception.
	*/
	public void restart(String cid) throws RemoteException;

	/**
	*	Downloads checkpointing data as SOAP attachment.
	*	<p>
	*	@param		cid client identification
	*	@return		checkpointing data
	*
	*	@throws		java.rmi.RemoteException standard java remote exception
	*				with detailed information about the exception.
	*/
	public DataHandler checkpointDownloadAttachment(String cid, String fileName) throws RemoteException;

	/**
	*	Uploads checkpointing data as SOAP attachment.
	*	<p>
	*	@param		cid client identification
	*	@param		dataHandler checkpointing data
	*
	*	@throws		java.rmi.RemoteException standard java remote exception
	*				with detailed information about the exception.
	*/
	public void checkpointUploadAttachment(String cid, DataHandler dataHandler) throws RemoteException;

}
