/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: rainer $
//					$Date: 2004/09/14 15:39:41 $
//					$Revision: 1.7 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.app;

import java.rmi.RemoteException;

import javax.activation.DataHandler;

/**
*	Interface representing the basic functionality of an application service
*	(inlcuding data upload, starting the native application and download the
*	results).
*
*	@author Ivona Brandic
*	@author Gerhard Engelbrecht
*	@author Rainer Schmidt
*/
public interface AppHandler {

	/**
	*	Uploads the input data file for the native application. The input data
	*	will be encoded as byte array (base64 in SOAP). The service-side name
	*	of the input file is specified in the application descriptor.
	*
	*	@param cid client identification
	*	@param file input data file
	*/
	public void upload(String cid, byte[] file) throws java.rmi.RemoteException;

	/**
	*	Downloads the specified output file from remote service. If no 
	*	file is given (filename is empty or null) the first output-file
	*	specified in the application descriptor will be downloaded. The
	*	resulting output data will be encoded as byte array (base64 in SOAP).
	*	<p>
	*	NOTE: The specified filenames have to be defined in the application
	*	descriptor!
	*	<p>
	*
	*	@param cid client identification
	*	@param fileName name of file 
	*	@return output data file
	*/
	public byte[] download(String cid, String fileName) throws RemoteException;
	
	/**
	*	Uploads the input data file for the native application. The input data
	*	will be encoded as data handler (Attachment in SOAP). The service-side
	*	name of the input file is specified in the application descriptor.
	*
	*	@param cid client identification
	*	@param dataHandler input data file represented as data handler
	*/
    public void uploadAttachment(String cid, DataHandler dataHandler) throws RemoteException;

	/**
	*	Downloads the specified output file from remote service. If no 
	*	file is given (filename is empty or null) the first output-file
	*	specified in the application descriptor will be downloaded. The
	*	resulting output data will be encoded as data handler (Attachment in
	*	SOAP). <p>
	*	NOTE: The specified filenames have to be defined in the application
	*	descriptor!
	*	<p>
	*
	*	@param cid client identification
	*	@param fileName output data file name 
	*	@return output data file
	*/
    public DataHandler downloadAttachment(String cid, String fileName) throws RemoteException;

 	/**
	*	Uploads the input data file for the native application. The input data
	*	will be encoded as String (base64 in SOAP). The service-side name
	*	of the input file is specified in the application descriptor.
	*
	*	@param cid client identification
	*	@param data input data file
	*/
   public void uploadString(String cid, String data) throws RemoteException;

	/**
	*	Downloads the specified output file from remote service. If no 
	*	file is given (filename is empty or null) the first output-file
	*	specified in the application descriptor will be downloaded. The
	*	resulting output data will be encoded as String (base64 in SOAP).
	*	<p>
	*	NOTE: The specified filenames have to be defined in the application
	*	descriptor!
	*	<p>
	*
	*	@param cid client identification
	*	@param fileName name of file 
	*	@return output data file
	*/
    public String downloadString(String cid, String fileName) throws RemoteException;

 	/**
	*	Starts the native application with the given job script. The name of
	*	the job script is specified in the application descriptor.
	*
	*	@param cid client identification
	*/
	public void start(String cid) throws java.rmi.RemoteException;

	/**
	*	Kills the native application with the given job script. The name of
	*	the kill script is specified in the application descriptor.
	*
	*	@param cid client identification
	*/
	public void kill(String cid) throws java.rmi.RemoteException;

	/**
	*	Returns the current status of this service execution. If no
	*	additional status information is specified in the application 
	*	descriptor this method only returns if the service is still running
	*	or if it has been finished/completed. The following return Strings
	*	which are encoded as byte arrays are supported:
	*	<ul>
	*	<li>NOT FINISHED</li>
	*	<li>FINISHED</li>
	*	</ul>
	*	<p>
	*	If additional status information is specified in the application 
	*	descriptor, it is possible to return a status-file during the 
	*	service execution. If a status-file is specified/available and the
	*	service is not finished the <code>getStatus</code> method returns
	*	the status-file as binary file (byte array).
	*	<p>
	*
	*	@param cid client identification
	*	@return status file (as byte array)
	*/
	public byte[] getStatus(String cid) throws java.rmi.RemoteException;

	/**
	*	Returns the current status of this service execution. If no
	*	additional status information is specified in the application 
	*	descriptor this method only returns if the service is still running
	*	or if it has been finished/completed. The following return Strings
	*	which are encoded as byte arrays are supported:
	*	<ul>
	*	<li>NOT FINISHED</li>
	*	<li>FINISHED</li>
	*	</ul>
	*	<p>
	*	If additional status information is specified in the application 
	*	descriptor, it is possible to return a status-file during the 
	*	service execution. If a status-file is specified/available and the
	*	service is not finished the <code>getStatus</code> method returns
	*	the status-file encoded as base64-encoded String.
	*	<p>
	*
	*	@param cid client identification
	*	@return status file (as String)
	*/
    public String getStatusAsString(String cid) throws java.rmi.RemoteException;
    
	/**
	*	Returns a service-wide unique identifier for clients.
	*
	*	@return unique identifier
	*/
	public String getCId() throws java.rmi.RemoteException;
    
	/**
	*	Acknowledges results from download and deletes server side files
	*	(input-, output- & status-files).
	*
	*	@param cid client identification
	*/
	public void acknowledgeResults(String cid) throws RemoteException;
	
	/**
	* Cleans a session directory from application state data (finish,
	* status file). This is required to restart a previously run
	* application.
	*/
	//public void resetSessionDir(String cid) throws RemoteException;
}
