/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/19 13:58:04 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.app;

import java.util.logging.Level;

import at.ac.univie.iss.service.HandlerFactory;
import at.ac.univie.iss.service.app.impl.AppHandlerImpl;
import at.ac.univie.iss.service.global.ServiceInfo;

/**
*	Concrete Factory class to create an <code>AppHandler</code> object.
*
*	@author Gerhard Engelbrecht
*
*	@see	at.ac.univie.iss.service.HandlerFactory
*/
final public class AppHandlerFactory extends HandlerFactory {

    /**
    *	Creates a new <code>AppHandlerFactory</code> instance.
    */
	public AppHandlerFactory() {
	}

    /**
    *	Returns a new <code>AppHandler</code> instance. This includes 
    *	initializing of the application handler.
    *	
    *	@return		new <code>AppHandler</code> instance.
    *
    *	@throws		Exception if a new <code>AppHandler</code> instance
    *				creation failed.
    */
	final public Object getHandler() throws Exception {
    
    	logger.log(Level.FINEST, "Started.\n");

        ServiceInfo.init();

    	logger.log(Level.FINEST, "Global service information initialized.\n");

        return (new AppHandlerImpl());
   
    }

}
