/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/13 19:51:55 $
//					$Revision: 1.2 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.app.impl;

import java.io.*;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

import at.ac.univie.iss.service.global.ServiceInfo;


class StdOutThread extends Thread {
         
     private static Logger logger = null;
     
     private BufferedReader stdInput = null;
     private BufferedReader stdError = null;
     private String id = null;
     
     StdOutThread(String id, InputStream inputStream, InputStream errorStream) throws RemoteException {
        
        this.id = id;
		try {
			logger = ServiceInfo.getLogger("app.scripts");
		}
		catch(Exception e) {
			if(logger == null) { e.printStackTrace(); }
			else { logger.log(Level.SEVERE, "",e); }

			throw new RemoteException("StdOutThread()",e);
		}	
         
		stdInput = new BufferedReader(new InputStreamReader(inputStream));

		stdError = new BufferedReader(new InputStreamReader(errorStream));
     }

	public void run() {
       
		String s;
       
		try{
			while ((s = stdInput.readLine()) != null) {
				logger.log(Level.FINE, "" + id + " - " + s + "\n");
			}
		}
		catch (IOException e){
			e.printStackTrace();
		}
	
		try {
			while ((s = stdError.readLine()) != null) {
				logger.log(Level.FINE, "" + id + " - " + s + "\n");
			}
		}
		catch (IOException e){
			e.printStackTrace();
		}
	}
}
 