/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/05/21 15:50:58 $
//					$Revision: 1.4 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.qos;

import java.util.logging.Level;

import at.ac.univie.iss.service.HandlerFactory;
import at.ac.univie.iss.service.qos.impl.QoSHandlerImpl;

/**
*	Concrete Factory class to create an <code>QoSHandler</code> object.
*
*	@author Gerhard Engelbrecht
*
*	@see	at.ac.univie.iss.service.HandlerFactory
*/
final public class QoSHandlerFactory extends HandlerFactory {
				   
    /**
    *	Creates a new <code>QoSHandlerFactory</code> instance.
    */
	public QoSHandlerFactory() {
	}

    /**
    *	Returns a new <code>QoSHandler</code> instance. This includes 
    *	initializing of the QoS handler.
    *	
    *	@return		new <code>QoSHandler</code> instance.
    *
    *	@throws		Exception if a new <code>QoSHandler</code> instance
    *				creation failed.
    */
    final public Object getHandler() throws Exception {
    
    	logger.log(Level.FINEST, "Started.\n");

        return (new QoSHandlerImpl());
   
    }

}
