/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:23:38 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.qos.state;

import java.io.Serializable;
import java.util.Vector;


final public class QoSDetails implements Serializable {

	private TSDescriptor confirmedDescriptor = null;
	private Vector inputs = null;
	private Vector outputs = null;

	public QoSDetails() {

		confirmedDescriptor = null;
		inputs = new Vector();
		outputs = new Vector();
	}

	public void addInputDescriptors(String qosDescriptor, String requestDescriptor) {
	
		TSDescriptors inDescs = new TSDescriptors(qosDescriptor, requestDescriptor);
		inputs.add(inDescs);
	}
	
	public Vector getInputDescriptors() {
		
		return this.inputs;
	}

	public void addOutputDescriptor(String qosDescriptor) {
	
		TSDescriptor outDesc = new TSDescriptor(qosDescriptor);
		outputs.add(outDesc);
	}

	public Vector getOutputDescriptors() {
	
		return this.outputs;
	}

	public void setConfirmedDescriptor(String qosDescriptor) {
	
		confirmedDescriptor = new TSDescriptor(qosDescriptor);
	}
	
	public TSDescriptor getConfirmedDescriptor() {
	
		return this.confirmedDescriptor;
	}
	
	public String toString() {
	
		StringBuffer buffer = new StringBuffer();

		buffer.append("[IN: " + this.inputs.size());
		buffer.append(", OUT: " + this.outputs.size());
		
		if (this.confirmedDescriptor != null) {
			
			buffer.append(", *CONFIRMED*]");
		}
		else {
			buffer.append(", *NULL*]");
		}

		return buffer.toString();
	}
	
}