/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:40:42 $
//					$Revision: 1.2 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.recovery;

import java.util.logging.Level;

import at.ac.univie.iss.service.HandlerFactory;
import at.ac.univie.iss.service.recovery.impl.RecoveryHandlerImpl;

/**
*	Concrete Factory class to create a <code>RecoveryHandler</code> object.
*
*	@author Gerhard Engelbrecht
*
*	@see	at.ac.univie.iss.service.HandlerFactory
*/
final public class RecoveryHandlerFactory extends HandlerFactory {
				   
    /**
    *	Creates a new <code>RecoveryHandlerFactory</code> instance.
    */
	public RecoveryHandlerFactory() {
	}

    /**
    *	Returns a new <code>RecoveryHandler</code> instance. This includes 
    *	initializing of the recovery handler.
    *	
    *	@return		new <code>RecoveryHandler</code> instance.
    *
    *	@throws		Exception if a new <code>RecoveryHandler</code> instance
    *				creation failed.
    */
    final public Object getHandler() throws Exception {
    
    	logger.log(Level.FINEST, "Started.\n");

        return (new RecoveryHandlerImpl());
   
    }

}
