/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:45:04 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.state;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

/**
*	The <code>Details</code> class holds state, id and optionally QoS
*	information for one specific client (consumer) - service (provider)
*	relation.<p>
*	Typically on every new client request a <code>Details</code> object is
*	created and stored in the details repository. Usually an interaction
*	between a client and the service (i.e. a method invocation) changes this
*	<code>Details</code> object e.g. by storing all input and output
*	descriptors of a QoS request (i.e. <code>requestQoSDescriptor</code> 
*	method).
*
*	@author		Gerhard Engelbrecht
*/
final public class Details implements Serializable {

	private Hashtable subDetails = null;

    /**
    *	Creates a new and empty <code>Details</code> object.
    */
	public Details() {

		subDetails = new Hashtable();
	}

	/**
	*	Sets a new sub-detail object (like <code>StateDetails</code>) with the
	*	given details name.
	*
	*	@param	detailsName name of this sub-details
	*	@param	detailsObject concrete sub-details object
	*/
	public void setDetails(Object detailsName, Object detailsObject) {
	
		subDetails.put(detailsName, detailsObject);
	}

	/**
	*	Returns the sub-detail object (like <code>StateDetails</code>)
	*	specified by the given details name.
	*
	*	@param	detailsName name of this sub-details
	*	@return	concrete sub-details object
	*/
	public Object getDetails(Object detailsName) {
	
		return subDetails.get(detailsName);
	}

	/**
	*	Returns <code>Details</code> object as String.
	*
	*	@return	String with this <code>Details</code> object.
	*/
	public String toString() {
	
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("[Details: ");

		Iterator entries = subDetails.entrySet().iterator();
		
		while (entries.hasNext()) {
		
			buffer.append(entries.next());
			
			if (entries.hasNext()) {
				buffer.append(", ");
			}			
		}
		buffer.append("]");
		
		return buffer.toString();
	}
}
