/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:45:04 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.state;

/**
*	The <code>DetailsRepository</code> interface encapsulates the concrete
*	implementation of the details repository used by each service. The 
*	details repository holds information about clients and their states
*	and optional information about the QoS state.
*
*	@author		Gerhard Engelbrecht
*/
public interface DetailsRepository {

    /**
    *	Returns a details object for the given cid (client identifier) from
    *	the details repository or null if no details could be found for the
    *	given cid. 
	*
	*	@param		cid client identifier
	*
    *	@return		details object.
    */
	public Details getDetails(String cid);

    /**
    *	Removes the details object with the given cid (client identifier) from
    *	the repository. 
	*
	*	@param		cid client identifier
	*
    *	@return		details object.
    */
	public Details removeDetails(String cid);

    /**
    *	Sets/adds the given details object to the repository. 
	*
	*	@param		details details object
    */
	public void setDetails(Details details);

    /**
    *	Returns a string representing this details repository. 
	*
	*	@return		String with this details repository.
    */
	public String toString();
}