/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:45:04 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.state;

import java.io.Serializable;

/**
*	The <code>IdDetails</code> class holds id information for one specific
*	client (consumer) - service (provider) relation. This includes ids for
*	job handling (job id), client idenfier (cid) and account identifier.
*
*	@author		Gerhard Engelbrecht
*/
final public class IdDetails implements Serializable {

	private String accountId = null;
	private String cId = null;
	private long jobId = -1L;

    /**
    *	Creates a new and empty <code>IdDetails</code> object.
    */
	public IdDetails() {

		accountId = null;
		cId = null;
		jobId = -1L;
	}

	/**
	*	Sets the account id for this <code>IdDetails</code> object. 
	*
	*	@param	accountId account id
	*/
	public void setAccountId(String accountId) {
	
		this.accountId = accountId;
	}

	/**
	*	Returns the account id for this <code>IdDetails</code> object. 
	*
	*	@return	account id
	*/
	public String getAccountId() {
	
		return this.accountId;
	}

	/**
	*	Sets the client idenfier (cid) for this <code>IdDetails</code> object.
	*
	*	@param	cId client identifier
	*/
	public void setCId(String cId) {
	
		this.cId = cId;
	}

	/**
	*	Returns the client idenfier (cid) for this <code>IdDetails</code> object. 
	*
	*	@return	client idenfier (cid)
	*/
	public String getCId() {
	
		return this.cId;
	}
	
	/**
	*	Sets the job identifier for this <code>IdDetails</code> object.
	*
	*	@param	jobId job identifier
	*/
	public void setJobId(long jobId) {
	
		this.jobId = jobId;
	}

	/**
	*	Returns the job identifier for this <code>IdDetails</code> object. 
	*
	*	@return	job identifier
	*/
	public long getJobId() {
	
		return this.jobId;
	}

	/**
	*	Returns this <code>IdDetails</code> object as String. 
	*
	*	@return	String for this <code>IdDetails</code>
	*/
	public String toString() {
	
		StringBuffer buffer = new StringBuffer();

		buffer.append("[CId: " + this.cId);
		buffer.append(", JobId: " + this.jobId);
		buffer.append(", AccountId: " + this.accountId + "]");
		
		return buffer.toString();
	}
}