/////////////////////////////////////////////////////////////////////////
//
//  Institute for Software Science, University of Vienna, 2004
//
// Copyright in this software belongs to Institute for Software Science, 
// University of Vienna, Nordbergstrasse 15/C/3, 1090 Vienna, Austria
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//	Created By :		Gerhard Engelbrecht
//	Created Date :		2004/04/20
//	Created for Project:	GEMSS
//
////////////////////////////////////////////////////////////////////////
//
// Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//	Last commit info:	$Author: gerry $
//					$Date: 2004/07/21 14:45:04 $
//					$Revision: 1.1 $
//
/////////////////////////////////////////////////////////////////////////

package at.ac.univie.iss.service.state;

/**
*	The <code>StateConstants</code> class holds all constants used by the
*	state information handling for the generic application service.
*
*	@author		Gerhard Engelbrecht
*/
final public class StateConstants {
	
	/**
	*	Constant for id details.
	*/
	final public static String IDDETAILS = new String("IdDetails");

	/**
	*	Constant for state details.
	*/
	final public static String STATEDETAILS = new String("StateDetails");

	/**
	*	Constant for QoS details.
	*/
	final public static String QOSDETAILS = new String("QoSDetails");

	final public static String OFFERING = new String("OFFERING");	
	final public static String OFFERED = new String("OFFERED");	
	final public static String OFFERINGFAILED = new String("OFFERINGFAILED");	

	final public static String CONFIRMING = new String("CONFIRMING");	
	final public static String CONFIRMED = new String("CONFIRMED");	
	final public static String CONFIRMINGFAILED = new String("CONFIRMINGFAILED");
	
	final public static String CANCELING = new String("CANCELING");	
	final public static String CANCELED = new String("CANCELED");	
	final public static String CANCELINGFAILED = new String("CANCELINGFAILED");	

	final public static String CHANGINGCID = new String("CHANGINGCID");	
	final public static String CHANGEDCID = new String("CHANGEDCID");	
	
	final public static String UPLOADED = new String("UPLOADED");	

	final public static String INSERTED = new String("INSERTED");	
	final public static String SUBMITTED = new String("SUBMITTED");	

	final public static String QUEUEING = new String("QUEUEING");	
	final public static String QUEUED = new String("QUEUED");	

	final public static String RUNNING = new String("RUNNING");	
	final public static String FINISHED = new String("FINISHED");	

	final public static String DOWNLOADED = new String("DOWNLOADED");	

	final public static String ACCEPTED = new String("ACCEPTED");	
	
	final public static String ERROR = new String("ERROR");	
	
	private StateConstants() {}
}
